% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_auc_ci.R
\name{auc_ci}
\alias{auc_ci}
\alias{auc_ci.aucs}
\title{Calculate CIs of ROC and precision-recall AUCs}
\usage{
auc_ci(curves, alpha = NULL, dtype = NULL)

\method{auc_ci}{aucs}(curves, alpha = 0.05, dtype = "normal")
}
\arguments{
\item{curves}{An \code{S3} object generated by \code{\link{evalmod}}.
  The \code{auc_ci} function accepts the following S3 objects.

  \tabular{lll}{
    \strong{\code{S3} object}
    \tab \strong{# of models}
    \tab \strong{# of test datasets} \cr

    smcurves \tab single   \tab multiple \cr
    mmcurves \tab multiple \tab multiple
  }

   See the \strong{Value} section of \code{\link{evalmod}} for more details.}

\item{alpha}{A numeric value of the significant level (default: 0.05)}

\item{dtype}{A string to specify the distribution used for CI calculation.
\tabular{ll}{
  \strong{dtype} \tab \strong{distribution} \cr
  normal (default) \tab Normal distribution \cr
  z \tab Normal distribution \cr
  t \tab t-distribution
}}
}
\value{
The \code{auc_ci} function returns a dataframe of AUC CIs.
}
\description{
The \code{auc_ci} function takes an \code{S3} object generated by
  \code{\link{evalmod}} and calculates CIs of AUCs when multiple data sets
  are specified.
}
\examples{

##################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(4, 100, 100, "good_er")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an smcurve object that contains ROC and Precision-Recall curves
smcurves <- evalmod(mdat)

## Calculate CI of AUCs
sm_auc_cis <- auc_ci(smcurves)

## Shows the result
sm_auc_cis

##################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(4, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mmcurves <- evalmod(mdat)

## Calculate CI of AUCs
mm_auc_ci <- auc_ci(mmcurves)

## Shows the result
mm_auc_ci

}
\seealso{
\code{\link{evalmod}} for generating \code{S3} objects with
  performance evaluation measures. \code{\link{auc}} for retrieving a dataset
  of AUCs.
}
