% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm2_join_data.R
\name{join_scores}
\alias{join_scores}
\title{Join scores of multiple models into a list}
\usage{
join_scores(..., byrow = FALSE, chklen = TRUE)
}
\arguments{
\item{...}{Multiple datasets. They can be vectors, arrays, matrices,
data frames, and lists.}

\item{byrow}{A Boolean value to specify whether row vectors are used
for matrix, data frame, and array.}

\item{chklen}{A Boolean value to specify whether all list items must be
the same lengths.}
}
\value{
The \code{join_scores} function returns a list that
  contains all combined score data.
}
\description{
The \code{join_scores} function takes predicted scores from multiple models
  and converts them to a list.
}
\examples{

## Add three numeric vectors
s1 <- c(1, 2, 3, 4)
s2 <- c(5, 6, 7, 8)
s3 <- c(2, 4, 6, 8)
scores1 <- join_scores(s1, s2, s3)

## Add a matrix and a numeric vector
a1 <- matrix(seq(8), 4, 2)
scores2 <- join_scores(a1, s3)

## Use byrow
a2 <- matrix(seq(8), 2, 4, byrow = TRUE)
scores3 <- join_scores(a2, s3, byrow = TRUE)

## Use chklen
s4 <- c(1, 2, 3)
s5 <- c(5, 6, 7, 8)
scores4 <- join_scores(s4, s5, chklen = FALSE)

}
\seealso{
\code{\link{evalmod}} for calculation evaluation measures.
  \code{\link{mmdata}} for formatting input data.
  \code{\link{join_labels}} for formatting labels with multiple datasets.
}

