% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_pi.R
\name{nb_pi}
\alias{nb_pi}
\title{Simple uncalibrated prediction intervals for negative-binomial data}
\usage{
nb_pi(
  newoffset,
  histoffset,
  lambda,
  kappa,
  q = qnorm(1 - 0.05/2),
  alternative = "both",
  newdat = NULL,
  histdat = NULL,
  algorithm = NULL
)
}
\arguments{
\item{newoffset}{number of experimental units in the future clusters}

\item{histoffset}{number of experimental units in the historical clusters}

\item{lambda}{overall Poisson mean}

\item{kappa}{dispersion parameter}

\item{q}{quantile used for interval calculation}

\item{alternative}{either "both", "upper" or "lower".
\code{alternative} specifies, if a prediction interval or
an upper or a lower prediction limit should be computed}

\item{newdat}{additional argument to specify the current data set}

\item{histdat}{additional argument to specify the historical data set}

\item{algorithm}{used to define the algorithm for calibration if called via
\code{quasi_pois_pi()}. This argument is not of interest for the calculation
of simple uncalibrated intervals}
}
\value{
\code{np_pi} returns an object of class \code{c("predint", "negativeBinomialPI")}.
}
\description{
\code{nb_pi()} is a helper function that is internally called by  \code{neg_bin_pi()}. It
calculates simple uncalibrated prediction intervals for negative-binomial data
with offsets.
}
\details{
This function returns a simple uncalibrated prediction interval
\deqn{[l,u]_m = n^*_m \hat{\lambda} \pm q \sqrt{n^*_m
\frac{\hat{\lambda} + \hat{\kappa} \bar{n} \hat{\lambda}}{\bar{n} H} +
(n^*_m \hat{\lambda} + \hat{\kappa} n^{*2}_m \hat{\lambda}^2)
}}

with \eqn{n^*_m} as the number of experimental units in \eqn{m=1, 2, ... , M} future clusters,
\eqn{\hat{\lambda}} as the estimate for the Poisson mean obtained from the
historical data, \eqn{\hat{\kappa}} as the estimate for the dispersion parameter,
\eqn{n_h} as the number of experimental units per historical cluster and
\eqn{\bar{n}=\sum_h^{n_h} n_h / H}. \cr

The direct application of this uncalibrated prediction interval to real life data
is not recommended. Please use the \code{neg_bin_pi()} function for real life applications.
}
\examples{
# Prediction interval
nb_pred <- nb_pi(newoffset=3, lambda=3, kappa=0.04, histoffset=1:9, q=qnorm(1-0.05/2))
summary(nb_pred)

}
