% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference.r
\docType{data}
\name{imap_stratified_summary}
\alias{imap_stratified_summary}
\alias{imap_summary}
\alias{imap}
\title{Data from the IMAP study}
\description{
The ``Improving Management of Abnormal Pap Smears'' study used a 
two-stage randomized preference trial design to evaluate psychosocial
outcomes in women found to have atypical cells in a Pap Smear.
Two systems for managing the atypical cells were tested (repeated Pap smears 
or HCV triage) and a doubly randomized design was used to evaluate the role 
of patient preference. The data set provides mean, standard deviation and 
sample sizes of the SF36 outcome for each treatment in both the choice and 
random arms.

Three data sets are provided with the preference package based on the
IMAP study. The first, \code{imap_summary} provides summary statistics
of the entire trial. The second \code{imap_summary_stratified}, summary
statistics of the study per strata. The third \code{imap} is a resampled
version of the individual level data including stratification. Each
of these data sets are compatible with the analysis functions 
\code{fit_preference_summary}, \code{fit_preference}, and 
\code{preference}, provided in this package. The examples sections
in the documentation illustrate their use.
}
\references{
McCaffery et al. (2010) "Psychosocial outcomes of three triage 
methods for the management of borderline abnormal cervical smears: an open 
randomised trial." \emph{BMJ}, \strong{340}:b4491.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2827716/}{PubMed})

McCaffery et al. (2011) "Determining the Impact of Informed 
Choice: Separating Treatment Effects from the Effects of Choice and Selection
in Randomized Trials." \emph{Med Decis Making}, \strong{31}(2):229-236.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/21041538}{PubMed})
}
\keyword{data}
