% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial-pref.r
\name{overall_sample_size_bin}
\alias{overall_sample_size_bin}
\title{Overall Sample Size Binomial}
\usage{
overall_sample_size_bin(
  power,
  phi,
  p11,
  p22,
  p1,
  p2,
  alpha = 0.05,
  theta = 0.5,
  xi = 1,
  nstrata = 1,
  k = 1
)
}
\arguments{
\item{power}{desired study power. Should be numeric value between 0 and 1.}

\item{phi}{the proportion of patients preferring treatment 1. Should be
numeric value between 0 and 1. If study is stratified, should be
vector with length equal to the number of strata in the study.}

\item{p11}{response proportion of patients choosing to receive treatment 1 
in the choice arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p22}{response proportion of patients choosing to receive treatment 2 
in the choice arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p1}{response proportion of patients randomized to receive treatment 1 
in the random arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{p2}{response proportion of patients randomized to receive treatment 2 
in the random arm. Should be numeric value between 0 and 1. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{alpha}{desired type I error rate.}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study 
and sum of vector should be 1. All vector elements should be
numeric values between 0 and 1. Default is 1 (i.e. unstratified 
design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}

\item{k}{the ratio of treatment A to treatment B in the random arm. 
(default 1, i.e. equal distribution to the two treatments in the 
random arm)}
}
\description{
Calculates the sample size required to detect a given set of effects
in a two-stage randomize clinical trial with a binary outcome. 
Returns the sample size for each of the three effects: preference,
selection and treatment
}
