% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reeh_ptp.R
\name{calculate_reeh_2019_clinical_ptp}
\alias{calculate_reeh_2019_clinical_ptp}
\title{Calculate 2019 Reeh Clinical PTP for obstructive CAD}
\usage{
calculate_reeh_2019_clinical_ptp(
  age,
  sex,
  symptom_type,
  have_dyslipidemia,
  have_family_history,
  have_diabetes
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{symptom_type}{Input characters (typical, atypical, nonanginal, dyspnoea)
to indicate the symptom characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
  \item dyspnoea stands for the patient having dyspnoea.
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_family_history}{Input characters (no, yes) to indicate if the patient
has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2019 Reeh et. al. clinical model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2019 Reeh et. al. clinical model.
}
\details{
The predictive model is based on 3903
patients free of CAD and heart failure and suspected of angina, who were referred
to a single, large, urban university hospital for assessment in 2012–15.
}
\examples{
# 40 year old female with typical chest pain
calculate_reeh_2019_clinical_ptp(
    age = 40,
    sex = "female",
    symptom_type = "typical",
    have_dyslipidemia = "no",
    have_family_history = "no",
    have_diabetes = "no"
)
}
