% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationfunctions.R
\name{A_to_X_dist}
\alias{A_to_X_dist}
\title{function to transform the distribution of stays to a fixed
point to the distribution of the staying times}
\usage{
A_to_X_dist(dist.point)
}
\arguments{
\item{dist.point}{vector of probabilities of staying
1:length(dist.point) days}
}
\value{
vector of probabilities
of being at the hospital for 1:length(dist.point) days at
random time of observation
}
\description{
function to transform the distribution of stays to a fixed
point to the distribution of the staying times
}
\examples{

# generate vector of probabilities for truncated Poisson distribution for 
# distribution of times of stay X
dist.X <- dpois(1:70, 4)
plot(dist.X)
# transform to distribution of distribution of staying-time up to observation point under
# assumption of steady state
dist.A <- X_to_A_dist(dist.X)
plot(dist.A)
# transform back to get original distribution
dist.X.2 <- A_to_X_dist(dist.A)
plot(dist.X.2)

}
