# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Project a set of points to the closest point on a curve
#'
#' Finds the projection index for a matrix of points \code{x}, when
#' projected onto a curve \code{s}. The curve need not be of the same
#' length as the number of points. If the points on the curve are not in
#' order, this order needs to be given as well, in \code{ord}.
#'
#' @param x a matrix of data points.
#' @param s a parametrized curve, represented by a polygon.
#' @param ord the order of the point in \code{s}. Default is the given order.
#' @param stretch A stretch factor for the endpoints of the curve,
#'   allowing the curve to grow to avoid bunching at the end.
#'   Must be a numeric value between 0 and 2.
#'
#' @return A structure is returned which represents a fitted curve.  It has components
#'   \item{s}{The fitted points on the curve corresponding to each point \code{x}}
#'   \item{ord}{the order of the fitted points}
#'   \item{lambda}{The projection index for each point}
#'   \item{dist}{The total squared distance from the curve}
#'   \item{dist_ind}{The squared distances from the curve to each of the respective points}
#'
#' @seealso \code{\link{principal_curve}}
#'
#' @keywords regression smooth nonparametric
#'
#' @export
project_to_curve <- function(x, s, ord = NULL, stretch = 2) {
    .Call('_princurve_project_to_curve', PACKAGE = 'princurve', x, s, ord, stretch)
}

