% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rij_matrix.R
\name{rij_matrix}
\alias{rij_matrix}
\alias{rij_matrix,Raster,Raster-method}
\alias{rij_matrix,Spatial,Raster-method}
\alias{rij_matrix}
\alias{rij_matrix}
\title{Feature by planning unit matrix}
\usage{
\S4method{rij_matrix}{Raster,Raster}(x, y, ...)

\S4method{rij_matrix}{Spatial,Raster}(x, y, ...)
}
\arguments{
\item{x}{\code{\link[raster]{Raster-class}} or
\code{\link[sp]{Spatial-class}} object representing the
planning units.}

\item{y}{\code{\link[raster]{Raster-class}} object representing the
features.}

\item{...}{additional arguments passed to \code{\link{fast_extract}} if
argument to \code{x} inherits from a \code{\link[sp]{Spatial-class}}
object.}
}
\value{
\code{\link{Matrix}{dgCMatrix-class}} object.
}
\description{
Generate a matrix showing the amount of each feature in each planning
unit (also known as an \emph{rij} matrix).Each row corresponds
to a different feature and each column corresponds to a different feature.
}
\details{
The sparse matrix represents the spatial intersection between the
  planning units and the features. Rows correspond to planning units,
  and columns correspond to features. Values correspond to the amount
  of the feature in the planning unit. For example, the amount of the
  third species in the second planning unit would be contained in the
  cell in the third column and in the second column.

  This function can take a long to run for big data sets. To reduce
  processing time, the \code{\link{set_number_of_threads}} function
  can be used to allocate more computational resources. Additionally,
  dealing with planning units represented with
  \code{\link[sp]{SpatialPolygonsDataFrame}} object, the
  \code{\link[velox]{velox}} package can be installed to reduce
  processing time.

  Generally, processing \code{\link[sp]{Spatial-class}} data takes much
  longer to process then \code{\link[raster]{Raster-class}} data, and
  so it is recommended to use \code{\link[raster]{Raster-class}} data
  for planning units where possible.
}
\examples{
# load data
data(sim_pu_raster, sim_pu_polygons, sim_pu_zones_stack)

# create rij matrix using raster layer planning units
rij_raster <- rij_matrix(sim_pu_raster, sim_features)
print(rij_raster)

# create rij matrix using polygon planning units
rij_polygons <- rij_matrix(sim_pu_polygons, sim_features)
print(rij_polygons)

# create rij matrix using raster stack planning units
rij_raster <- rij_matrix(sim_pu_zones_stack, sim_features)
print(rij_raster)
}
\seealso{
\code{\link{set_number_of_threads}}, \code{\link[velox]{velox}}.
}
