% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gap_portfolio.R
\name{add_gap_portfolio}
\alias{add_gap_portfolio}
\title{Add a gap portfolio}
\usage{
add_gap_portfolio(x, number_solutions, pool_gap = 0.1)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{number_solutions}{\code{integer} number of solutions required.}

\item{pool_gap}{\code{numeric} gap to optimality for solutions in the portfolio.
This relative gap specifies a threshold worst-case performance for
solutions in the portfolio. For example, value of 0.1 will result in the
portfolio returning solutions that are within 10\% of an optimal solution.
Note that the gap specified in the solver (i.e.
\code{\link{add_gurobi_solver}} must be less than or equal to the gap
specified to generate the portfolio. Defaults to 0.1.}
}
\value{
\code{\link{ConservationProblem-class}} object with the portfolio
  added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
\code{\link{problem}} by finding a certain number of solutions that
are all within a pre-specified optimality gap. This method is useful for
generating multiple solutions that can be used to calculate selection
frequencies for moderate and large-sized problems (similar to
\emph{Marxan}).
}
\details{
This strategy for generating a portfolio requires problems to
  be solved using the \emph{Gurobi} software suite (i.e. using
  \code{\link{add_gurobi_solver}}. Specifically, version 9.0.0 (or greater)
  of the \pkg{gurobi} package must be installed.
  Note that the number of solutions returned may be less than the argument to
  \code{number_solutions}, if the total number of solutions that
  meet the optimality gap is less than the number of solutions requested.
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(600)

# load data
data(sim_pu_raster, sim_features)

# create minimal problem with a portfolio containing 10 solutions within 20\%
# of optimality
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.05) \%>\%
      add_gap_portfolio(number_solutions = 5, pool_gap = 0.2) \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem and generate portfolio
s1 <- solve(p1)

# print number of solutions found
print(length(s1))

# plot solutions
plot(stack(s1), axes = FALSE, box = FALSE)

# create multi-zone  problem with a portfolio containing 10 solutions within
# 20\% of optimality
p2 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_gap_portfolio(number_solutions = 5, pool_gap = 0.2) \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem and generate portfolio
s2 <- solve(p2)

# print number of solutions found
print(length(s2))

# plot solutions in portfolio
plot(stack(lapply(s2, category_layer)), main = "solution", axes = FALSE,
     box = FALSE)
}
}
\seealso{
\code{\link{portfolios}}.
}
