% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizationProblem-proto.R
\name{OptimizationProblem-class}
\alias{OptimizationProblem-class}
\alias{OptimizationProblem}
\title{Optimization problem class}
\description{
The \code{OptimizationProblem} class is used to represent an optimization
problem. Data are stored in memory and accessed using an external pointer.
\strong{Only experts should interact with this class directly.}
}
\section{Fields}{

\describe{
\item{$ptr}{\code{externalptr} object.}
}
}

\section{Usage}{

\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$ncol()}

\code{x$nrow()}

\code{x$ncell()}

\code{x$modelsense()}

\code{x$vtype()}

\code{x$obj()}

\code{x$A()}

\code{x$rhs()}

\code{x$sense()}

\code{x$lb()}

\code{x$ub()}

\code{x$number_of_planning_units()}

\code{x$number_of_features()}

\code{x$number_of_zones()}

\code{x$row_ids()}

\code{x$col_ids()}

\code{x$compressed_formulation()}
}

\section{Arguments}{

\describe{
\item{ptr}{\code{externalptr} object.}
}
}

\section{Details}{

\describe{

\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{ncol}{\code{integer} number of columns (variables) in model matrix.}

\item{nrow}{\code{integer} number of rows (constraints) in model matrix.}

\item{ncell}{\code{integer} number of cells in model matrix.}

\item{modelsense}{\code{character} model sense.}

\item{vtype}{\code{character} vector of variable types.}

\item{obj}{\code{numeric} vector of objective function.}

\item{A}{\code{\linkS4class{dgCMatrix}} model matrix }

\item{rhs}{\code{numeric} vector of right-hand-side constraints.}

\item{sense}{\code{character} vector of constraint senses.}

\item{lb}{\code{numeric} vector of lower bounds for each decision variable.}

\item{ub}{\code{numeric} vector of upper bounds for each decision variable.}

\item{number_of_features}{\code{integer} number of features in the problem.}

\item{number_of_planning_units}{\code{integer} number of planning units in
the problem.}

\item{number_of_zones}{\code{integer} number of zones in the
problem.}

\item{col_ids}{\code{character} names describing each decision variable
(column) in the model matrix.}

\item{row_ids}{\code{character} names describing each constraint (row) in
in the model matrix.}

\item{compressed_formulation}{is the optimization problem formulated
using a compressed version of the rij matrix?}

\item{shuffle_columns}{randomly shuffle the columns in the problem. This
should almost never be called manually and only should only be called
after the optimization problem has been fully constructed.}

}
}

