% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marxan_connectivity_data_to_matrix.R
\name{marxan_connectivity_data_to_matrix}
\alias{marxan_connectivity_data_to_matrix}
\title{Convert \emph{Marxan} connectivity data to matrix format}
\usage{
marxan_connectivity_data_to_matrix(x, data, symmetric = TRUE)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e., \code{\linkS4class{ConservationProblem}}) object that
contains planning unit and zone data to ensure that the argument to
\code{data} is converted correctly. This argument can be set to
\code{NULL} if checks are not required (not recommended).}

\item{data}{\code{data.frame} object with the columns \code{"id1"},
\code{"id2"}, and \code{"boundary"}. The columns \code{"zone1"} and
\code{"zone2"} can also be provided to indicate zone data.}

\item{symmetric}{\code{logical} does the connectivity data
describe symmetric relationships between planning units?
If the data contain asymmetric connectivity data,
this parameter should be set to \code{FALSE}.
Defaults to \code{TRUE}.}
}
\value{
\code{array} or \code{\linkS4class{dgCMatrix}} sparse matrix object.
If the argument to \code{data} corresponds to a single zone,
then a \code{\linkS4class{dgCMatrix}}
matrix is returned. Otherwise, if the argument to \code{data}
corresponds to multiple zones, then an \code{array} is returned.
}
\description{
Convert a \code{data.frame} object containing \emph{Marxan} connectivity data
to matrix format. This function is designed specifically for
connectivity data (not boundary data).
It ensures that the output matrix correctly specifies
symmetric or asymmetric connectivity relationships between planning units.
}
\examples{
\dontrun{
# create marxan connectivity data with four planning units and one zone,
# and symmetric connectivity values
bldf1 <- expand.grid(id1 = seq_len(4), id2 = seq_len(4))
bldf1$boundary <- 1
bldf1$boundary[bldf1$id1 == bldf1$id2] <- 0.5

# print data
print(bldf1)

# convert to matrix
m1 <- marxan_connectivity_data_to_matrix(NULL, bldf1)

# print matrix
print(m1)

# visualize matrix
image(m1)

# create marxan connectivity data with four planning units and one zone,
# and asymmetric connectivity values
bldf2 <- expand.grid(id1 = seq_len(4), id2 = seq_len(4))
bldf2$boundary <- runif(nrow(bldf2))
bldf2$boundary[bldf1$id1 == bldf1$id2] <- 0.5

# print data
print(bldf2)

# convert to matrix
m2 <- marxan_connectivity_data_to_matrix(NULL, bldf2, symmetric = FALSE)

# print matrix
print(m2)

# visualize matrix
image(m2)

# create marxan connectivity with three planning units and two zones,
# and symmetric connectivity values
bldf3 <- expand.grid(id1 = seq_len(3), id2 = seq_len(3),
                     zone1 = c("z1", "z2"),
                     zone2 = c("z1", "z2"))
bldf3$boundary <- 1
bldf3$boundary[bldf2$id1 == bldf2$id2 & bldf2$zone1 == bldf2$zone2] <- 0.5
bldf3$boundary[bldf2$id1 == bldf2$id2 & bldf2$zone1 != bldf2$zone2] <- 0

# print data
print(bldf3)

# convert to array
m3 <- marxan_connectivity_data_to_matrix(NULL, bldf3)

# print array
print(m3)
}
}
