% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_species}
\alias{simulate_species}
\title{Simulate species habitat suitability data}
\usage{
simulate_species(x, n = 1, scale = 0.5)
}
\arguments{
\item{x}{\code{\link[raster:raster]{raster::raster()}} raster object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{scale}{\code{numeric} parameter to control level of spatial
auto-correlation.
Defaults to 0.5.}
}
\value{
\code{\linkS4class{RasterStack}} object.
}
\description{
Generates simulated species data using Gaussian random fields.
Specifically, it outputs spatially auto-correlated raster data with
values between zero and one.
}
\examples{
\dontrun{
# create raster
r <- raster(ncol = 10, nrow = 10, xmn = 0, xmx = 1, ymn = 0, ymx = 1)
values(r) <- 1

# simulate data for 4 species
spp <- simulate_species(r, 4)

# plot simulated species
plot(spp, main = "simulated species distributions")
}

}
\seealso{
\code{\link[=simulate_data]{simulate_data()}}.
}
