% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_total_units.R
\name{number_of_total_units}
\alias{number_of_total_units}
\alias{number_of_total_units.ConservationProblem}
\title{Number of total units}
\usage{
number_of_total_units(x, ...)

\method{number_of_total_units}{ConservationProblem}(x, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{...}{not used.}
}
\value{
An \code{integer} number of total units.
}
\description{
Extract the number of total units in an object.
}
\details{
The total units for an object corresponds to the total number
of entries (e.g., rows, cells) for the planning unit data.
For example, a single-layer raster dataset might have 90 cells
and only two of these cells contain non-missing (\code{NA}) values.
As such, this dataset would have 90 total units and two planning units.
}
\examples{
\dontrun{
# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_zones_features <- get_sim_zones_features()

# create problem with one zone
p1 <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.2) \%>\%
  add_binary_decisions()

# print number of planning units
print(number_of_planning_units(p1))

# print number of total units
print(number_of_total_units(p1))

# create problem with multiple zones
p2 <-
  problem(sim_zones_pu_raster, sim_zones_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(matrix(0.2, ncol = 3, nrow = 5)) \%>\%
  add_binary_decisions()

# print number of planning units
print(number_of_planning_units(p2))

# print number of total units
print(number_of_total_units(p2))
}
}
