% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerscale_derivative.R
\name{powerscale_derivative}
\alias{powerscale_derivative}
\title{Derivative with respect to power-scaling}
\usage{
powerscale_derivative(x, log_component, quantity = "mean", ...)
}
\arguments{
\item{x}{Posterior draws.}

\item{log_component}{Log likelihood or log prior values.}

\item{quantity}{Character specifying quantity of interest (default
is "mean"). Options are "mean", "sd", "var".}

\item{...}{unused}
}
\value{
Derivative of the quantity with respect to log2 of the
power-scaling factor (alpha).
}
\description{
Calculate the analytical derivative of a quantity with respect to
power-scaling prior or likelihood.
}
\examples{
example_model <- example_powerscale_model()
draws <- example_model$draws
log_prior <- log_prior_draws(draws, joint = TRUE)
posterior::summarise_draws(
    posterior::subset_draws(draws, variable = c("mu", "sigma")),
    mean,
    mean_sens = ~powerscale_derivative(.x, log_prior, quantity = "mean")
)
}
