% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-validate.R
\name{cal_validate_linear}
\alias{cal_validate_linear}
\alias{cal_validate_linear.resample_results}
\alias{cal_validate_linear.rset}
\title{Measure performance with and without using linear regression calibration}
\usage{
cal_validate_linear(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)

\method{cal_validate_linear}{resample_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)

\method{cal_validate_linear}{rset}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  metrics = NULL,
  save_pred = FALSE,
  ...
)
}
\arguments{
\item{.data}{An \code{rset} object or the results of \code{\link[tune:fit_resamples]{tune::fit_resamples()}} with
a \code{.predictions} column.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{metrics}{A set of metrics passed created via \code{\link[yardstick:metric_set]{yardstick::metric_set()}}}

\item{save_pred}{Indicates whether to a column of post-calibration predictions.}

\item{...}{Options to pass to \code{\link[=cal_estimate_logistic]{cal_estimate_logistic()}}, such as the \code{smooth}
argument.}
}
\description{
Measure performance with and without using linear regression calibration
}
\section{Performance Metrics}{


By default, the average of the root mean square error (RMSE) is returned.
Any appropriate \code{\link[yardstick:metric_set]{yardstick::metric_set()}} can be used. The validation
function compares the average of the metrics before, and after the calibration.
}

\examples{
library(dplyr)
library(yardstick)
library(rsample)

head(boosting_predictions_test)

reg_stats <- metric_set(rmse, ccc)

set.seed(828)
boosting_predictions_oob \%>\%
  # Resample with 10-fold cross-validation
  vfold_cv() \%>\%
  cal_validate_linear(truth = outcome, smooth = FALSE, metrics = reg_stats)
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_estimate_linear]{cal_estimate_linear()}}
}
