% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-isotonic.R
\name{cal_estimate_isotonic_boot}
\alias{cal_estimate_isotonic_boot}
\alias{cal_estimate_isotonic_boot.data.frame}
\alias{cal_estimate_isotonic_boot.tune_results}
\alias{cal_estimate_isotonic_boot.grouped_df}
\title{Uses a bootstrapped Isotonic regression model to calibrate probabilities}
\usage{
cal_estimate_isotonic_boot(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  times = 10,
  parameters = NULL,
  ...
)

\method{cal_estimate_isotonic_boot}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  times = 10,
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_isotonic_boot}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  times = 10,
  parameters = NULL,
  ...
)

\method{cal_estimate_isotonic_boot}{grouped_df}(
  .data,
  truth = NULL,
  estimate = NULL,
  times = 10,
  parameters = NULL,
  ...
)
}
\arguments{
\item{.data}{An ungrouped \code{data.frame} object, or \code{tune_results} object,
that contains predictions and probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{times}{Number of bootstraps.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new probabilities.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Uses a bootstrapped Isotonic regression model to calibrate probabilities
}
\details{
This function uses \code{\link[stats:isoreg]{stats::isoreg()}} to create obtain the calibration
values. It runs \code{\link[stats:isoreg]{stats::isoreg()}} multiple times, and each time with a different
seed. The results are saved inside the returned \code{cal_object}.
}
\section{Multiclass Extension}{


This method is designed to work with two classes. For multiclass, it creates
a set of "one versus all" calibrations for each class. After they are
applied to the data, the probability estimates are re-normalized to add to
one. This final step might compromise the calibration.
}

\examples{
# It will automatically identify the probability columns
# if passed a model fitted with tidymodels
cal_estimate_isotonic_boot(segment_logistic, Class)
# Specify the variable names in a vector of unquoted names
cal_estimate_isotonic_boot(segment_logistic, Class, c(.pred_poor, .pred_good))
# dplyr selector functions are also supported
cal_estimate_isotonic_boot(segment_logistic, Class, dplyr::starts_with(".pred"))
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_validate_isotonic_boot]{cal_validate_isotonic_boot()}}
}
