% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xor.R
\name{xor}
\alias{xor}
\title{XOR}
\usage{
xor(activity_a, activity_b)
}
\arguments{
\item{activity_a}{\code{\link{character}}: Activity A. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{activity_b}{\code{\link{character}}: Activity B. This should be an activity of the log supplied to \code{\link{check_rule}}.}
}
\description{
Check for exclusiveness of two activities.

If \code{activity_a} exists, \code{activity_b} should not exist, and vice versa.
}
\examples{
library(bupaR)
library(eventdataR)

# A patient should not receive both an X-Ray and MRI Scan.
patients \%>\%
 check_rule(xor("X-Ray","MRI SCAN"))

}
\seealso{
Other Exclusiveness rules: 
\code{\link{and}()}
}
\concept{Exclusiveness rules}
