% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_management.R
\name{file_management}
\alias{file_management}
\alias{new_project_group}
\alias{rename_folder}
\alias{move_project}
\alias{copy_project}
\alias{archive_project}
\alias{open_project}
\alias{move_projects_folder}
\alias{rename_projects_folder}
\title{file management}
\usage{
new_project_group(path)

rename_folder(project, new_folder_name, archived = FALSE)

move_project(project, path, make_directories = FALSE, archived = FALSE)

copy_project(
  project_to_copy,
  path,
  new_id = NA,
  new_folder_name = paste0("p", stringr::str_pad(new_id, 4, pad = "0")),
  new_short_title = NA,
  make_directories = FALSE,
  archived = FALSE
)

archive_project(project)

open_project(project, new_session = FALSE, archived = FALSE)

move_projects_folder(
  new_path,
  make_directories = FALSE,
  .Renviron_path = file.path(Sys.getenv("HOME"), ".Renviron")
)

rename_projects_folder(
  new_name,
  .Renviron_path = file.path(Sys.getenv("HOME"), ".Renviron")
)
}
\arguments{
\item{path}{A valid path string.

  For \code{copy_project()} only, if left blank, the preexisting project's
  directory is used. All other functions here require a valid path.

  See the \code{path} argument in \code{\link{new_project}()} for details on
  valid paths.}

\item{project}{Project \code{id} or unambiguous substring of the project name
from the \code{\link{projects}()} table}

\item{new_folder_name}{Character string of new name for project folder.
Always processed with \code{fs::\link[fs]{path_sanitize}()}.}

\item{archived}{Logical indicating whether or not the function should
consider archived projects when determining which project the user is
referring to in the \code{project}/\code{project_to_copy} argument.
\code{FALSE} by default. See \strong{Details}.}

\item{make_directories}{Logical. If the path represented by the \code{path}
parameter does not exist, should the needed directories be created?}

\item{project_to_copy}{Project \code{id} or unambiguous substring of the
project name corresponding to the project that is to be copied.}

\item{new_id}{Optional integer, ranging from 1 to 9999, used as the
newly-created project \code{id}. Must not already exist in
\code{\link{projects}()$id}. If left blank, the lowest available \code{id}
will be automatically used.}

\item{new_short_title}{Optional character string that becomes the
\code{short_title} of the project copy. It also becomes the project copy's
folder name under normal circumstances (see \strong{Details}).}

\item{new_session}{Same as the \code{newSession} argument in
\code{rstudioapi::\link[rstudioapi]{openProject}()}.}

\item{new_path}{A valid string indicating a path where the projects folder
should be moved. The projects folder will have the same name, but it will
be moved into this directory.}

\item{.Renviron_path}{The full file path of the .Renviron file where the user
would like to store the updated \code{\link{projects_folder}()} path.
Default is the home .Renviron file. If the file doesn't exist it will be
created. See also \code{\link{setup_projects}()}.}

\item{new_name}{A valid directory name for the projects folder.}
}
\description{
Tools for Organizing and Managing Project Files
}
\details{
Projects can be moved (\code{move_project()}), copied
(\code{copy_project()}), or archived (\code{archive_project}()).

The difference between \code{delete_project()} and \code{archive_project()}
is that the latter will just move the project to a directory called
\emph{archive}, located in the same parent directory as the project. This
directory gets created if it doesn't yet exist. Most functions that perform
actions on projects will exclude archived projects by default in order to
make it easier for the user to enter a nonambiguous string that will match an
active (i.e., non-archived) project.

Projects can also be organized into groups. By default, all projects are
created within the main \link[=projects_folder]{projects folder}. To create a
project group, which is essentially a subfolder of the main
\link[=projects_folder]{projects folder}, use \code{new_project_group()}.

\code{open_project()} is a wrapper around
\code{rstudioapi::\link[rstudioapi]{openProject}()}, but the user only needs
to know the project's \code{id}, \code{title}, or \code{short_title} instead
of the file path of the project's \emph{.Rproj} file. If there is no
\emph{.Rproj} file in the project's folder, the user has the option to
restore a default \emph{.Rproj} file. If there are multiple \emph{.Rproj}
files, an error is thrown.

\code{move_projects_folder()} allows the user to move the entire projects
folder created by \code{\link{setup_projects}()} into a different directory,
and \code{rename_projects_folder()} changes its name.
}
\examples{
#############################################################################
# SETUP
old_home <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
Sys.setenv(HOME = temp_dir)
setup_projects(path = temp_dir)
#############################################################################

# setting up a simple project directory tree
new_project_group("kidney/clinical")
new_project_group("kidney/genomics")
new_project_group("prostate/clinical")
new_project_group("prostate/genomics")

# Wrapped in if (interactive()) because it requires interactive console input
# and fails automated package checking and testing.
if (interactive()){
  new_project(title = "Sample Authorless Project", parent_directory = "kidney")

  # Moving the project folder, then moving it again.
  move_project(project = 1, "kidney/genomics")
  move_project(project = "Sample Authorless Project", "prostate/clinical")

  # Copying the project
  copy_project(project_to_copy = 1, "kidney/clinical")

  # Renaming the folder of the copy of the project
  rename_folder(project = 2, "copy")

  # Archiving the copy of the project
  archive_project(2)

  # Moving and renaming the entire projects folder
  temp_dir2 <- tempfile("dir")
  dir.create(temp_dir2)
  move_projects_folder(temp_dir2)
  projects_folder()
  rename_projects_folder("foobar")
  projects_folder()

  # Opens the project in same session
  open_project("Sample")

  # Opens the project in a new session
  open_project(1, new_session = TRUE)
}
#############################################################################
# CLEANUP
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
\seealso{
\code{\link{new_project}()} and \code{\link{delete_project}()} for
  other functions that write and delete files.
}
