% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varsel.R
\name{varsel}
\alias{varsel}
\alias{varsel.default}
\alias{varsel.refmodel}
\title{Variable selection (without cross-validation)}
\usage{
varsel(object, ...)

\method{varsel}{default}(object, ...)

\method{varsel}{refmodel}(
  object,
  d_test = NULL,
  method = NULL,
  ndraws = NULL,
  nclusters = 20,
  ndraws_pred = 400,
  nclusters_pred = NULL,
  refit_prj = !inherits(object, "datafit"),
  nterms_max = NULL,
  verbose = TRUE,
  lambda_min_ratio = 1e-05,
  nlambda = 150,
  thresh = 1e-06,
  regul = 1e-04,
  penalty = NULL,
  search_terms = NULL,
  seed = sample.int(.Machine$integer.max, 1),
  ...
)
}
\arguments{
\item{object}{An object of class \code{refmodel} (returned by \code{\link[=get_refmodel]{get_refmodel()}} or
\code{\link[=init_refmodel]{init_refmodel()}}) or an object that can be passed to argument \code{object} of
\code{\link[=get_refmodel]{get_refmodel()}}.}

\item{...}{Arguments passed to \code{\link[=get_refmodel]{get_refmodel()}} as well as to the divergence
minimizer (during a forward search and also during the evaluation part, but
the latter only if \code{refit_prj} is \code{TRUE}).}

\item{d_test}{For internal use only. A \code{list} providing information about the
test set which is used for evaluating the predictive performance of the
reference model. If not provided, the training set is used.}

\item{method}{The method for the search part. Possible options are \code{"L1"} for
L1 search and \code{"forward"} for forward search. If \code{NULL}, then \code{"forward"}
is used if the reference model has multilevel or additive terms and \code{"L1"}
otherwise. See also section "Details" below.}

\item{ndraws}{Number of posterior draws used in the search part. Ignored if
\code{nclusters} is not \code{NULL} or in case of L1 search (because L1 search always
uses a single cluster). If both (\code{nclusters} and \code{ndraws}) are \code{NULL}, the
number of posterior draws from the reference model is used for \code{ndraws}.
See also section "Details" below.}

\item{nclusters}{Number of clusters of posterior draws used in the search
part. Ignored in case of L1 search (because L1 search always uses a single
cluster). For the meaning of \code{NULL}, see argument \code{ndraws}. See also
section "Details" below.}

\item{ndraws_pred}{Only relevant if \code{refit_prj} is \code{TRUE}. Number of
posterior draws used in the evaluation part. Ignored if \code{nclusters_pred} is
not \code{NULL}. If both (\code{nclusters_pred} and \code{ndraws_pred}) are \code{NULL}, the
number of posterior draws from the reference model is used for
\code{ndraws_pred}. See also section "Details" below.}

\item{nclusters_pred}{Only relevant if \code{refit_prj} is \code{TRUE}. Number of
clusters of posterior draws used in the evaluation part. For the meaning of
\code{NULL}, see argument \code{ndraws_pred}. See also section "Details" below.}

\item{refit_prj}{A single logical value indicating whether to fit the
submodels along the solution path again (\code{TRUE}) or to retrieve their fits
from the search part (\code{FALSE}) before using those (re-)fits in the
evaluation part.}

\item{nterms_max}{Maximum number of predictor terms until which the search is
continued. If \code{NULL}, then \code{min(19, D)} is used where \code{D} is the number of
terms in the reference model (or in \code{search_terms}, if supplied). Note that
\code{nterms_max} does not count the intercept, so use \code{nterms_max = 0} for the
intercept-only model. (Correspondingly, \code{D} above does not count the
intercept.)}

\item{verbose}{A single logical value indicating whether to print out
additional information during the computations.}

\item{lambda_min_ratio}{Only relevant for L1 search. Ratio between the
smallest and largest lambda in the L1-penalized search. This parameter
essentially determines how long the search is carried out, i.e., how large
submodels are explored. No need to change this unless the program gives a
warning about this.}

\item{nlambda}{Only relevant for L1 search. Number of values in the lambda
grid for L1-penalized search. No need to change this unless the program
gives a warning about this.}

\item{thresh}{Only relevant for L1 search. Convergence threshold when
computing the L1 path. Usually, there is no need to change this.}

\item{regul}{A number giving the amount of ridge regularization when
projecting onto (i.e., fitting) submodels which are GLMs. Usually there is
no need for regularization, but sometimes we need to add some
regularization to avoid numerical problems.}

\item{penalty}{Only relevant for L1 search. A numeric vector determining the
relative penalties or costs for the predictors. A value of \code{0} means that
those predictors have no cost and will therefore be selected first, whereas
\code{Inf} means those predictors will never be selected. If \code{NULL}, then \code{1} is
used for each predictor.}

\item{search_terms}{A custom character vector of terms to consider for the
search. The intercept (\code{"1"}) needs to be included explicitly. The default
considers all the terms in the reference model's formula.}

\item{seed}{Pseudorandom number generation (PRNG) seed by which the same
results can be obtained again if needed. If \code{NULL}, no seed is set and
therefore, the results are not reproducible. See \code{\link[=set.seed]{set.seed()}} for details.
Here, this seed is used for clustering the reference model's posterior
draws (if \code{!is.null(nclusters)}) and for drawing new group-level effects
when predicting from a multilevel submodel (however, not yet in case of a
GAMM).}
}
\value{
An object of class \code{vsel}. The elements of this object are not meant
to be accessed directly but instead via helper functions (see the vignette
or type \code{?projpred}).
}
\description{
Perform the projection predictive variable selection for GLMs, GLMMs, GAMs,
and GAMMs. This variable selection consists of a \emph{search} part and an
\emph{evaluation} part. The search part determines the solution path, i.e., the
best submodel for each submodel size (number of predictor terms). The
evaluation part determines the predictive performance of the submodels along
the solution path.
}
\details{
Arguments \code{ndraws}, \code{nclusters}, \code{nclusters_pred}, and \code{ndraws_pred}
are automatically truncated at the number of posterior draws in the
reference model (which is \code{1} for \code{datafit}s). Using less draws or clusters
in \code{ndraws}, \code{nclusters}, \code{nclusters_pred}, or \code{ndraws_pred} than posterior
draws in the reference model may result in slightly inaccurate projection
performance. Increasing these arguments affects the computation time
linearly.

For argument \code{method}, there are some restrictions: For a reference model
with multilevel or additive formula terms, only the forward search is
available.

L1 search is faster than forward search, but forward search may be more
accurate. Furthermore, forward search may find a sparser model with
comparable performance to that found by L1 search, but it may also start
overfitting when more predictors are added.

An L1 search may select interaction terms before the corresponding main
terms are selected. If this is undesired, choose the forward search
instead.
}
\examples{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  # Data:
  dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

  # The "stanreg" fit which will be used as the reference model (with small
  # values for `chains` and `iter`, but only for technical reasons in this
  # example; this is not recommended in general):
  fit <- rstanarm::stan_glm(
    y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
    QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
  )

  # Variable selection (here without cross-validation and with small values
  # for `nterms_max`, `nclusters`, and `nclusters_pred`, but only for the
  # sake of speed in this example; this is not recommended in general):
  vs <- varsel(fit, nterms_max = 3, nclusters = 5, nclusters_pred = 10,
               seed = 5555)
  # Now see, for example, `?print.vsel`, `?plot.vsel`, `?suggest_size.vsel`,
  # and `?solution_terms.vsel` for possible post-processing functions.
}

}
\seealso{
\code{\link[=cv_varsel]{cv_varsel()}}
}
