% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promotion_impact.R
\name{detectOutliers}
\alias{detectOutliers}
\title{detect some outliers}
\usage{
detectOutliers(
  model,
  threshold = list(cooks.distance = 1, dfbetas = 1, dffits = 2),
  option = 2
)
}
\arguments{
\item{model}{Execution result object : promotionImpact}

\item{threshold}{List of threshold values to be determined as outliers if greater than the written values}

\item{option}{The number of indicators that must be greater than the threshold values to be outliers.}
}
\description{
detectOutliers
}
\details{
detectOutliers extracts outliers which affect the average effects of promotions.
}
\examples{
\dontshow{
sim.data.sub <- sim.data \%>\% filter(dt <= '2015-05-01')
sim.promotion.sub <- sim.promotion \%>\% filter(start_dt <= '2015-05-01')
pri1 <- promotionImpact(data=sim.data.sub, promotion=sim.promotion.sub, 
                       time.field = 'dt', target.field = 'simulated_sales', 
                       trend = FALSE, period = NULL, structural.change = FALSE,
                       logged = TRUE, differencing = TRUE, synergy.promotion = FALSE,
                       synergy.var = NULL, allow.missing = TRUE)
}
\donttest{
pri1 <- promotionImpact(data=sim.data, promotion=sim.promotion, 
                       time.field = 'dt', target.field = 'simulated_sales', 
                       trend = FALSE, period = NULL, structural.change = FALSE,
                       logged = TRUE, differencing = TRUE, synergy.promotion = FALSE,
                       synergy.var = NULL, allow.missing = TRUE)
out <- detectOutliers(model = pri1, 
                      threshold = list(cooks.distance=1, dfbetas=1, dffits=2), option = 1)
}
}
