% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biproportional.R
\name{biproporz}
\alias{biproporz}
\title{Biproportional apportionment}
\usage{
biproporz(
  votes_matrix,
  district_seats,
  quorum,
  use_list_votes = TRUE,
  method = "round"
)
}
\arguments{
\item{votes_matrix}{Vote count matrix with votes by party in rows and votes by district
in columns}

\item{district_seats}{Vector defining the number of seats per district. Must be the same
length as \code{ncol(votes_matrix)}. Values are name-matched to \code{votes_matrix} if both are
named. If the number of seats per district should be assigned according to the number
of votes (not the general use case), a single number for the total number of seats can
be used.}

\item{quorum}{Optional list of functions which take the votes_matrix and return a logical
vector that denotes for each list/party whether they reached the quorum (i.e. are
eligible for seats). The easiest way to do this is via \code{\link[=quorum_any]{quorum_any()}} or
\code{\link[=quorum_all]{quorum_all()}}, see examples. Alternatively you can pass a precalculated logical
vector. No quorum is applied if parameter is missing or \code{NULL}.}

\item{use_list_votes}{By default (\code{TRUE}) it's assumed that each voter in a district has
as many votes as there are seats in a district. Thus, votes are weighted according to
the number of available district seats with \code{\link[=weight_list_votes]{weight_list_votes()}}. Set to \code{FALSE} if
\code{votes_matrix} shows the number of voters (e.g. they can only cast one vote for one
party).}

\item{method}{Defines which method is used to assign seats. The following methods are
recommended:
\itemize{
\item{\code{round}: Uses the Sainte-Laguë/Webster method (rounding half up) for the upper
and lower apportionment which is the standard for biproportional apportionment and
the only method guaranteed to terminate.}
\item{\code{wto}: "winner take one" works like "round" with a condition that the party that
got the most votes in a district must get \emph{at least} one seat ('Majorzbedingung')
in said district. Seats in the upper apportionment are assigned with
Sainte-Laguë/Webster. \code{votes_matrix} must have row and column names to use this
method. See \code{\link[=lower_apportionment]{lower_apportionment()}} for more details.}
}
It is also possible to use any divisor method name listed in \code{\link[=proporz]{proporz()}}. If you want to
use a different method for the upper and lower apportionment, provide a list with two
entries.}
}
\value{
Matrix with the same dimension as \code{votes_matrix} containing the number of seats
with the row and column divisors stored in attributes (hidden from print, see
\code{\link[=get_divisors]{get_divisors()}}).
}
\description{
Method to proportionally allocate seats among parties (or lists) and districts (or
entities, regions), thus bi-proportional.
}
\details{
Each party nominates a candidate list for every district. The voters vote for
the parties of their district. The seat allocation is calculated in two steps:
\enumerate{
\item In the so called \code{\link[=upper_apportionment]{upper apportionment}}
the number of seats for each party (over all districts) is determined.
Normally, the number of seats for each region are defined before the
election and are independent of the vote counts.
\item In the so called \code{\link[=lower_apportionment]{lower apportionment}}
the seats are distributed to the regional party list respecting the
results from the upper apportionment.
}

Parties failing to reach quorums cannot get seats. This function does not handle seat
assignment to candidates.
}
\note{
The iterative process in the lower apportionment is only guaranteed to terminate
with the default Sainte-Laguë/Webster method.
}
\examples{
votes_matrix = uri2020$votes_matrix
district_seats = uri2020$seats_vector

biproporz(votes_matrix, district_seats)

# apply quorum (high values for illustrative purposes)
biproporz(votes_matrix, district_seats,
          quorum_all(any_district = 0.1, total = 0.25))

}
\references{
Gaffke, Norbert; Pukelsheim, Friedrich (2008): Divisor methods for
proportional representation systems: An optimization approach to vector and matrix
apportionment problems. Mathematical Social Sciences, 56 (2), 166-184.
}
\seealso{
\code{\link[=pukelsheim]{pukelsheim()}} for biproportional apportionment with \code{data.frames} as inputs.
}
