## ---- dpi = 72-----------------------------------------------------------
set.seed(12345)
N <- 100
X <- data.frame(a=(1:N), b=(1:N) * rnorm(N, 10, 0.1),
                c=(N:1), d=(N:1) * rnorm(N, 10, 1.0))

## ---- dpi = 72, results = "hide"-----------------------------------------
library(propr)
phi <- phit(X, symmetrize = TRUE)
rho <- perb(X, ivar = 0)

## ---- dpi = 72-----------------------------------------------------------
rho99 <- rho[">", .99]
rho99@pairs

## ---- dpi = 72-----------------------------------------------------------
rhoab <- subset(rho, select = c("a", "b"))
rhoab@matrix

## ---- dpi = 72-----------------------------------------------------------
simplify(rho99)

## ---- dpi = 72, results = "hide", fig.show = "hold", fig.keep = "last"----
plot(rho99)

## ---- dpi = 72-----------------------------------------------------------
N <- 100
a <- seq(from = 5, to = 15, length.out = N)
b <- a * rnorm(N, mean = 1, sd = 0.1)
c <- rnorm(N, mean = 10)
d <- rnorm(N, mean = 10)
e <- rep(10, N)
X <- data.frame(a, b, c, d, e)

## ---- dpi = 72-----------------------------------------------------------
Y <- X / rowSums(X) * abs(rnorm(N))

## ---- dpi = 72-----------------------------------------------------------
all(round(X[, 2] / X[, 1] - Y[, 2] / Y[, 1], 5) == 0)

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(X)

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(Y)

## ---- dpi = 72, warning = FALSE------------------------------------------
suppressWarnings(cor(X))
cor(Y)

## ---- dpi = 72-----------------------------------------------------------
propr:::proprVLR(Y[, 1:4])
propr:::proprVLR(X)

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(propr:::proprCLR(Y[, 1:4]))

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(propr:::proprCLR(X))

## ---- dpi = 72-----------------------------------------------------------
phit(Y[, 1:4])@matrix
phit(X)@matrix

## ---- dpi = 72-----------------------------------------------------------
perb(Y[, 1:4])@matrix
perb(X)@matrix

## ---- dpi = 72-----------------------------------------------------------
cor(Y)
perb(Y)@matrix

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(propr:::proprALR(Y, ivar = 5))

## ---- dpi = 72, fig.show = "hold"----------------------------------------
pairs(X[, 1:4])

## ---- dpi = 72-----------------------------------------------------------
perb(Y, ivar = 5)@matrix

## ---- dpi = 72-----------------------------------------------------------
pairs(propr:::proprALR(X, ivar = 1))

## ---- dpi = 72-----------------------------------------------------------
perb(X, ivar = 1)@matrix

## ---- dpi = 72-----------------------------------------------------------
dendrogram(perb(X, ivar = 1))

## ---- dpi = 72-----------------------------------------------------------
perb(Y[, 2:5], ivar = 4)@matrix
perb(X, ivar = 5)@matrix

