\name{mascot}

\alias{mascot}

\alias{plot.mascot}
\alias{plot.mascot_query}
\alias{is.mascot}
\alias{is.mascot_query}
\alias{as.data.frame.mascot}
\alias{summary.mascot}

\alias{as.psm.mascot_query}

\title{
  Generic methods for mascot results
}
\description{
  does something with a \code{mascot} object using the package's functions, 
  e.g., \code{\link{peakplot}} or \code{\link{lcmsmap}}.
}

\usage{

  \method{is}{mascot}(obj)

  \method{plot}{mascot}(x, \dots)
  
  \method{as.data.frame}{mascot}(x, \dots)
  
  \method{summary}{mascot}(object, \dots)
  
  \method{is}{mascot_query}(obj)
    
  \method{plot}{mascot_query}(x, obj = NULL, FUN = defaultIon, \dots)
}

\arguments{

  \item{x}{
    a \code{mascot_query} or \code{mascot} S3 class object.
  }
  
  \item{object}{
    a \code{mascot} S3 class object.
  }
  
   \item{obj}{
    a \code{mascot} S3 class object.
  }
  
  \item{\dots}{
    arguments will be passwed through.
  }
  
    \item{FUN}{
    ion series.
  }
}

\details{
the object has been generated by using the mascot server command
  \code{./export_dat_2.pl $EXPORTOPTIONS file=$DAT}.
  
  \code{$EXPORTOPTIONS} is defined as \code{"_minpeplen=5 _server_mudpit_switch=0.000000001 _showsubsets=1 _sigthreshold=0.05 do_export=1 export_format=XML group_family=1 pep_calc_mr=1 pep_delta=1 pep_end=1 pep_exp_mr=1 pep_exp_mz=1 pep_exp_z=1 pep_expect=1 pep_isbold=1 pep_isunique=1 pep_miss=1 pep_query=1 pep_rank=1 pep_scan_title=1 pep_score=1 pep_seq=1 pep_start=1 pep_var_mod=1 peptide_master=1 prot_acc=1 prot_cover=1 prot_desc=1 prot_empai=1 prot_hit_num=1 prot_len=1 prot_mass=1 prot_matches=1 prot_pi=1 prot_score=1 prot_seq=1 protein_master=1 query_master=1 query_params=1 query_peaks=1 query_qualifiers=1 query_raw=1 query_title=1 search_master=1 show_format=1 show_header=1 show_masses=1 show_mods=1 show_params=1 show_pep_dupes=1 use_homology=1 user=command line"}.
  
  \code{$DAT} defines the mascot result file.
  
  The output is written as XML file the following command is applied:
  \code{XML::xmlToList(XML::xmlParse(xml_file_name))}.
  
  \link[XML]{xmlParse} and \link[XML]{xmlToList} are function of the XML package.
}

\value{
  returns the \link{peakplot} return value. 
}

\references{
  \url{http://www.matrixscience.com/mascot_support_v2_6.html}
}
\author{

  Christian Panse, 2017

}

\seealso{
  \itemize{
  
    \item \code{\link{summary.mascot}}
    
    \item \code{\link{peakplot}}
    
    \item \url{https://CRAN.R-project.org/package=XML}
  }
}
\examples{
\dontrun{
  # plot the top ten highes scored PSMs
  par(ask = TRUE)
  idx <- order(protViz:::.mascot.get.pep_score(S), decreasing = TRUE)[1:10]
  rv.peakplot <- lapply(S$queries[idx], plot)
  
  
  myAA <- do.call('rbind', lapply(F225712$masses, 
    function(x){
      data.frame(letter1=as.character(x$.attrs), mass=as.numeric(x$text))
      }))
      
  aa2mass("ELVISR", mass=myAA$mass[1:25], letter1 = myAA$letter1[1:25])
  
}
}
