% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_sequence_coverage.R
\name{qc_sequence_coverage}
\alias{qc_sequence_coverage}
\title{Protein coverage distribution}
\usage{
qc_sequence_coverage(
  data,
  protein_identifier,
  coverage,
  sample = NULL,
  interactive = FALSE
)
}
\arguments{
\item{data}{A data frame containing at least the input variables.}

\item{protein_identifier}{Column in the data frame containing protein identifiers.}

\item{coverage}{Column in the data frame containing protein coverage in percent. This information can be obtained using
the \code{\link{sequence_coverage}} function.}

\item{sample}{Column in the data frame containing sample names. Please only provide this argument if you want to
facet the distribution plot by sample otherwise do not provide this argument.}

\item{interactive}{A logical, if TRUE the plot is interactive (default is TRUE).}
}
\value{
A protein coverage histogram with 5 percent binwidth. The vertical dotted line indicates the median.
}
\description{
Plots the distribution of protein coverages in a histogram.
}
\examples{
\dontrun{
qc_sequence_coverage(
  data,
  protein_identifier = pg_protein_accessions,
  coverage = coverage
)
}

}
\seealso{
\code{\link{sequence_coverage}}
}
