% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_protti.R
\name{anova_protti}
\alias{anova_protti}
\title{Perform ANOVA}
\usage{
anova_protti(data, grouping, condition, mean_ratio, sd, n)
}
\arguments{
\item{data}{a data frame containing at least the input variables.}

\item{grouping}{a character column in the \code{data} data frame that contains precursor or
peptide identifiers.}

\item{condition}{a character or numeric column in the \code{data} data frame that contains the
conditions.}

\item{mean_ratio}{a numeric column in the \code{data} data frame that contains mean intensities
or mean intensity ratios.}

\item{sd}{a numeric column in the \code{data} data frame that contains the standard deviation
corresponding to the mean.}

\item{n}{a numeric column in the \code{data} data frame that contains the number of replicates
for which the corresponding mean was calculated.}
}
\value{
a data frame that contains the within group error (\code{ms_group}) and the between
group error (\code{ms_error}), f statistic and p-values.
}
\description{
Performs an ANOVA statistical test
}
\examples{
data <- data.frame(
  precursor = c("A", "A", "A", "B", "B", "B"),
  condition = c("C1", "C2", "C3", "C1", "C2", "C3"),
  mean = c(10, 12, 20, 11, 12, 8),
  sd = c(2, 1, 1.5, 1, 2, 4),
  n = c(4, 4, 4, 4, 4, 4)
)

anova_protti(
  data,
  grouping = precursor,
  condition = condition,
  mean = mean,
  sd = sd,
  n = n
)
}
