% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_chebi.R
\name{fetch_chebi}
\alias{fetch_chebi}
\title{Fetch ChEBI database information}
\usage{
fetch_chebi(relation = FALSE, stars = c(3), timeout = 60)
}
\arguments{
\item{relation}{a logical value that indicates if ChEBI Ontology data will be returned instead
the main compound data. This data can be used to check the relations of ChEBI ID's to each other.
Default is FALSE.}

\item{stars}{a numeric vector indicating the "star" level (confidence) for which entries should
be retrieved (Possible levels are 1, 2 and 3). Default is \code{c(3)} retrieving only "3-star"
entries, which are manually annotated by the ChEBI curator team.}

\item{timeout}{a numeric value specifying the time in seconds until the download of an organism
archive times out. The default is 60 seconds.}
}
\value{
A data frame that contains information about each molecule in the ChEBI database.
}
\description{
Fetches information from the ChEBI database.
}
\examples{
\donttest{
chebi <- fetch_chebi()

head(chebi)
}
}
