% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_mobidb.R
\name{fetch_mobidb}
\alias{fetch_mobidb}
\title{Fetch protein disorder and mobility information from MobiDB}
\usage{
fetch_mobidb(
  uniprot_ids = NULL,
  organism_id = NULL,
  show_progress = TRUE,
  timeout = 60,
  max_tries = 2
)
}
\arguments{
\item{uniprot_ids}{optional, a character vector of UniProt identifiers for which information
should be fetched. This argument is mutually exclusive to the \code{organism_id} argument.}

\item{organism_id}{optional, a character value providing the NCBI taxonomy identifier of an organism
(TaxId) of an organism for which all available information should be retreived. This
argument is mutually exclusive to the \code{uniprot_ids} argument.}

\item{show_progress}{a logical value; if \code{TRUE} a progress bar will be shown.
Default is \code{TRUE}.}

\item{timeout}{a numeric value specifying the time in seconds until the download of an organism
archive times out. The default is 60 seconds.}

\item{max_tries}{a numeric value that specifies the number of times the function tries to download
the data in case an error occurs. The default is 2.}
}
\value{
A data frame that contains start and end positions for disordered and flexible protein
regions. The \code{feature} column contains information on the source of this
annotation. More information on the source can be found
\href{https://mobidb.bio.unipd.it/about/mobidb}{here}.
}
\description{
Fetches information about disordered and flexible protein regions from MobiDB.
}
\examples{
\donttest{
fetch_mobidb(
  uniprot_ids = c("P0A799", "P62707")
)
}
}
