/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.http.HttpHandler;
import com.qarks.util.http.HttpRequest;
import com.qarks.util.http.HttpResponse;
import com.qarks.util.http.MimeUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;

public class HttpFileHandler
implements HttpHandler {
    private File rootDir = null;
    private String rootDirPath = null;

    public HttpFileHandler(File file) {
        this.rootDir = file;
        this.rootDirPath = file.getAbsolutePath().replace('\\', '/');
    }

    public String getRootPath() {
        return this.rootDir.getAbsolutePath();
    }

    public File getRootDir() {
        return this.rootDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String string = URLDecoder.decode(httpRequest.getResourceName(), "utf-8");
        File file = new File(this.rootDirPath + string);
        if (!this.isUnderRoot(file)) return;
        httpResponse.getHeaders().setHeaderValue("Content-type", MimeUtils.guessContentTypeFromName(file.getName()));
        Date date = new Date(file.lastModified());
        Date date2 = new Date();
        String string2 = date.toGMTString();
        String string3 = date2.toGMTString();
        httpResponse.getHeaders().setHeaderValue("Last-Modified", string2);
        httpResponse.getHeaders().setHeaderValue("Content-Length", Long.toString(file.length()));
        httpResponse.getHeaders().setHeaderValue("Date", string3);
        if (httpRequest.method.equals("GET")) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                byte[] byArray = new byte[2000];
                long l = file.length();
                long l2 = 0L;
                boolean bl = false;
                while (!bl) {
                    int n = bufferedInputStream.read(byArray);
                    if (n <= -1) throw new IOException("EOF reached");
                    bl = (l2 += (long)n) == l;
                    httpResponse.sendResponsePacket(l, byArray, n, bl);
                }
                if (l2 == l) return;
                System.err.println("could not send the whole file");
                return;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        } else {
            if (!httpRequest.method.equals("HEAD")) return;
            httpResponse.sendErrorCode("HTTP/1.0 200 OK");
        }
    }

    @Override
    public String getName() {
        return "";
    }

    public boolean isUnderRoot(File file) {
        String string;
        boolean bl = false;
        if (this.rootDir != null && file != null && file.exists() && (string = file.getAbsolutePath().replace('\\', '/')).indexOf("//") == -1) {
            int n;
            while ((n = string.indexOf("/..")) != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 3);
                n = string2.lastIndexOf("/");
                if (n <= -1) continue;
                string = string2.substring(0, n) + string3;
            }
            bl = string.startsWith(this.rootDirPath);
        }
        return bl;
    }
}

