/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff;

public class FileLine {
    public static final int UNKNOWN = 0;
    public static final int UNCHANGED = 1;
    public static final int MOVED = 2;
    public static final int MODIFIED = 3;
    public static final int INSERTED_ON_OTHER_SIDE = 4;
    public static final int DELETED_ON_OTHER_SIDE = 5;
    public static final int CONFLICT = 6;
    public static final int NO_MATCH = -1;
    private EolType eolType;
    private String line;
    private int indexInOtherVersion = -1;
    private boolean matchFound = false;
    private int index;
    private int status = -1;
    private int hashcode = -1;

    public FileLine(String string, int n, EolType eolType) {
        this.line = string;
        this.index = n;
        this.eolType = eolType;
    }

    public static FileLine getFormattingLine(int n) {
        FileLine fileLine = new FileLine("", -1, EolType.IGNORE);
        fileLine.status = n;
        return fileLine;
    }

    public EolType getEolType() {
        return this.eolType;
    }

    public static String statusToString(int n) {
        String string = "?";
        switch (n) {
            case 6: {
                string = "conflict";
                break;
            }
            case 5: {
                string = "deleted on other side";
                break;
            }
            case 4: {
                string = "inserted on other side";
                break;
            }
            case 3: {
                string = "modified";
                break;
            }
            case 2: {
                string = "moved";
                break;
            }
            case -1: {
                string = "no match";
                break;
            }
            case 1: {
                string = "unchanged";
            }
        }
        return string;
    }

    public String getContent() {
        return this.line;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isMatchFound() {
        return this.matchFound;
    }

    public int indexInOtherVersion() {
        return this.indexInOtherVersion;
    }

    public int getStatus() {
        return this.status;
    }

    public void setIndexInOtherVersion(int n) {
        this.matchFound = true;
        this.indexInOtherVersion = n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String toString() {
        return this.line;
    }

    public int getHashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.line.hashCode();
        }
        return this.hashcode;
    }

    public boolean matches(FileLine fileLine, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            String string = this.line;
            while (string.startsWith(" ") || string.startsWith("\t")) {
                string = string.substring(1);
            }
            String string2 = fileLine.getContent();
            while (string2.startsWith(" ") || string2.startsWith("\t")) {
                string2 = string2.substring(1);
            }
            bl2 = string.length() == string2.length() && string.hashCode() == string2.hashCode() && fileLine.eolType == this.eolType;
        } else if (this.line.length() == fileLine.getContent().length() && this.getHashCode() == fileLine.getHashCode() && fileLine.eolType == this.eolType) {
            bl2 = true;
        }
        return bl2;
    }

    public static enum EolType {
        IGNORE,
        NO_EOL,
        CR,
        LF,
        CRLF;

    }
}

