/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GradientPaintPanel
extends JPanel {
    private static final double FACTOR = 0.9;
    private Color previousLeftColor = Color.black;
    private Color previousRightColor = Color.black;

    public GradientPaintPanel() {
        this.setOpaque(true);
    }

    public static Color darker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.9), 0), Math.max((int)((double)color.getGreen() * 0.9), 0), Math.max((int)((double)color.getBlue() * 0.9), 0));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color = (Color)UIManager.get("Panel.background");
        if (!color.toString().equals(this.previousLeftColor.toString())) {
            this.previousLeftColor = color;
            this.previousRightColor = GradientPaintPanel.darker(this.previousLeftColor);
        }
        super.paintComponent(graphics);
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.previousRightColor, dimension.width, 0.0f, this.previousLeftColor, false));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
    }
}

