/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.proxy.server;

import com.qarks.util.http.HttpHandler;
import com.qarks.util.http.HttpRequest;
import com.qarks.util.http.HttpResponse;
import com.qarks.util.proxy.common.InvocationResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class InvocationHttpHandler
implements HttpHandler {
    protected Map<String, Object> handlerTable = new Hashtable<String, Object>();
    protected Map<String, Boolean> paramFlagTable = new Hashtable<String, Boolean>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        try {
            String string = httpRequest.getParameter("class");
            String string2 = httpRequest.getParameter("method");
            Object object = this.handlerTable.get(string);
            if (object == null) throw new Exception("proxy implementation of <" + string + "> not found while handling http request");
            boolean bl = this.paramFlagTable.get(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(httpRequest.getInputStream());
            Vector vector = (Vector)objectInputStream.readObject();
            Class[] classArray = (Class[])vector.elementAt(0);
            Object[] objectArray = (Object[])vector.elementAt(1);
            InvocationResult invocationResult = null;
            Method method = object.getClass().getMethod(string2, classArray);
            Object object2 = null;
            if (method == null) throw new Exception("method <" + string2 + "> of the proxy implementation <" + string + "> not found while handling http request");
            try {
                object2 = method.invoke(object, objectArray);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3;
                System.err.println(throwable.getMessage());
                if (throwable instanceof InvocationTargetException && (throwable3 = ((InvocationTargetException)throwable).getTargetException()) instanceof Serializable) {
                    throwable2 = throwable3;
                }
                invocationResult = InvocationResult.getExceptionResult(throwable2);
                this.sendResponse(httpResponse, invocationResult);
            }
            invocationResult = bl ? InvocationResult.getResult(object2, objectArray) : InvocationResult.getResult(object2);
            this.sendResponse(httpResponse, invocationResult);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            throw new Exception(exception);
        }
    }

    @Override
    public String getName() {
        return "/rmi";
    }

    private void sendResponse(HttpResponse httpResponse, Object object) throws IOException {
        byte[] byArray = this.getObjectAsBytes(object);
        httpResponse.sendResponsePacket(byArray.length, byArray, byArray.length, true);
    }

    private byte[] getObjectAsBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private static String getClassName(Class clazz) {
        String string = clazz.getName();
        int n = 0;
        n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void addProxyImplementation(Class clazz, Object object) {
        if (object != null) {
            this.addProxyImplementation(InvocationHttpHandler.getClassName(clazz), object);
        }
    }

    public void addProxyImplementation(String string, Object object, boolean bl) {
        this.handlerTable.put(string, object);
        this.paramFlagTable.put(string, bl);
    }

    public void addProxyImplementation(String string, Object object) {
        this.addProxyImplementation(string, object, false);
    }

    public void removeProxyImplementation(String string) {
        this.handlerTable.remove(string);
        this.paramFlagTable.remove(string);
    }
}

