% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.distributional}
\alias{read.distributional}
\title{Read a .csv file with distributional data}
\usage{
read.distributional(
  fname,
  errorfile = NA,
  method = "KS",
  xlab = "age [Ma]",
  colmap = "rainbow",
  sep = ",",
  dec = ".",
  header = TRUE,
  check.names = FALSE,
  ...
)
}
\arguments{
\item{fname}{the path of a .csv file with the input data, arranged
in columns.}

\item{errorfile}{the (optional) path of a .csv file with the
standard errors of the input data, arranged by column in the
same order as \code{fname}. Must be specified if the data are
to be compared with the Sircombe-Hazelton dissimilarity.}

\item{method}{an optional string specifying the dissimilarity
measure which should be used for comparing this with other
datasets. Should be one of either \code{"KS"} (for
Kolmogorov-Smirnov), \code{"Kuiper"} (for Kuiper) or
\code{"SH"} (for Sircombe and Hazelton). If \code{method =
"SH"}, then \code{errorfile} should be specified. If
\code{method = "SH"} and \code{errorfile} is unspecified, then
the program will default back to the Kolmogorov-Smirnov
dissimilarity.}

\item{xlab}{an optional string specifying the nature and units of
the data.  This string is used to label kernel density
estimates.}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the
data.}

\item{sep}{the field separator character.  Values on each line of
the file are separated by this character.}

\item{dec}{the character used in the file for decimal points.}

\item{header}{a logical value indicating whether the file contains
the names of the variables as its first line.}

\item{check.names}{logical.  If \code{TRUE} then the names of the
variables in the frame are checked to ensure that they are
syntactically variable names.}

\item{...}{optional arguments to the built-in \code{read.csv}
function}
}
\value{
an object of class \code{distributional}, i.e. a list with
    the following items:

\code{x}: a named list of vectors containing the numerical data for
each sample

\code{err}: an (optional) named list of vectors containing the
standard errors of \code{x}

\code{method}: either "KS" (for Kolmogorov-Smirnov), "Kuiper" (for
the Kuiper statistic) or "SH" (for Sircombe Hazelton)

\code{breaks}: a vector with the locations of the histogram bin edges

\code{xlab}: a string containing the label to be given to the
x-axis on all plots

\code{colmap}: the colour map provided by the input argument

\code{name}: the name of the data object, extracted from the file path
}
\description{
Reads a data table containing distributional data, i.e. lists of
continuous data such as detrital zircon U-Pb ages.
}
\examples{
    agefile <- system.file("DZ.csv",package="provenance")
    errfile <- system.file("DZerr.csv",package="provenance")
    DZ <- read.distributional(agefile,errfile)
    plot(KDE(DZ$x$N1))
}
