% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarities.R
\name{bray.diss}
\alias{bray.diss}
\alias{bray.diss.default}
\alias{bray.diss.compositional}
\title{Bray-Curtis dissimilarity}
\usage{
bray.diss(x, ...)

\method{bray.diss}{default}(x, y, ...)

\method{bray.diss}{compositional}(x, ...)
}
\arguments{
\item{x}{a vector containing the first compositional sample}

\item{...}{optional arguments}

\item{y}{a vector of \code{length(x)} containing the second
compositional sample}
}
\value{
a scalar value
}
\description{
Calculates the Bray-Curtis dissimilarity between two samples
}
\examples{
data(Namib)
print(bray.diss(Namib$HM$x["N1",],Namib$HM$x["N2",]))
}
