% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_pspatreg.R
\name{methods_pspatreg}
\alias{methods_pspatreg}
\alias{anova}
\alias{anova.pspatreg}
\alias{coef}
\alias{coef.pspatreg}
\alias{fitted}
\alias{fitted.pspatreg}
\alias{logLik}
\alias{logLik.pspatreg}
\alias{residuals}
\alias{residuals.pspatreg}
\alias{vcov}
\alias{vcov.pspatreg}
\alias{print}
\alias{print.pspatreg}
\title{Methods for class pspatreg}
\usage{
\method{anova}{pspatreg}(object, ..., lrtest = TRUE)

\method{coef}{pspatreg}(object, ...)

\method{fitted}{pspatreg}(object, ...)

\method{logLik}{pspatreg}(object, ..., REML = FALSE)

\method{residuals}{pspatreg}(object, ...)

\method{vcov}{pspatreg}(object, ..., bayesian = TRUE)

\method{print}{pspatreg}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{a `pspatreg` object created by 
\code{\link{pspatfit}}.}

\item{...}{further arguments passed to or from other methods.}

\item{lrtest}{logical value to compute likelihood ratio
test for nested models in `anova` method. Default = `TRUE`}

\item{REML}{logical value to get restricted log-likelihood 
instead of the usual log-likelihood. Default = `FALSE`}

\item{bayesian}{logical value to get bayesian or frequentist
covariance matrix for parametric terms. Default = `FALSE`}

\item{x}{similar to \code{object} argument for \code{print()} 
and \code{plot} functions.}

\item{digits}{number of digits to show in printed tables.
Default: max(3L, getOption("digits") - 3L).}
}
\value{
\code{anova:} An object of class \emph{anova}. Can be printed
  with \code{summary}. 
  If argument \code{lrtest = TRUE} (default), the object 
  returned includes an LR test for nested models. 
  In this case, a warning message is printed to emphasize 
  that the LR test remains valid only for nested models.

\code{coef:} A numeric vector including spatial parameters and
  parameters corresponding to parametric covariates. 
  Also includes fixed parameters for non-parametric 
  covariates. Can be printed with \code{print}.

\code{fitted:} A numeric vector including fitted values for the 
  dependent variable.

\code{logLik:} An object of class \emph{logLik}. Can be printed
  with \code{print}.
  If argument \code{REML = FALSE} (default), the object returns 
  the value of log-likelihood function in the optimum. 
  If argument \code{REML = TRUE}, the object returns 
  the value of restricted log-likelihood function in 
  the optimum.

\code{residuals:} A numeric vector including residuals of the model.

\code{vcov:} A matrix including the covariance matrix for the
  estimated parameters.
  If argument \code{bayesian = TRUE} (default), the 
  covariance matrix is computed using bayesian
  method. 
  If argument \code{bayesian = FALSE} , the 
  covariance matrix is computed using sandwich method. 
  See Fahrmeir et al. (2021) for details.

\code{print:} No return value
}
\description{
The \code{\link{anova}} function provides tables of fitted 
  `pspatreg` models including information criteria (AIC and BIC), 
  log-likelihood and degrees of freedom of each fitted model. The 
  argument `lrtest` allows to perform LR tests between nested models.
  The \code{\link{print}} function is used to print short tables including the 
  values of beta and spatial coefficients as well as p-values of significance test for each 
  coefficient. This can be used as an alternative to 
 \code{\link{summary.pspatreg}} when a brief output is needed. 
 The rest of methods works in the usual way.
}
\examples{
library(pspatreg)
###############################################
# Examples using spatial data of Ames Houses.
###############################################
# Getting and preparing the data
library(spdep)
library(sf)
ames <- AmesHousing::make_ames() # Raw Ames Housing Data
ames_sf <- st_as_sf(ames, coords = c("Longitude", "Latitude"))
ames_sf$Longitude <- ames$Longitude
ames_sf$Latitude <- ames$Latitude
ames_sf$lnSale_Price <- log(ames_sf$Sale_Price)
ames_sf$lnLot_Area <- log(ames_sf$Lot_Area)
ames_sf$lnTotal_Bsmt_SF <- log(ames_sf$Total_Bsmt_SF+1)
ames_sf$lnGr_Liv_Area <- log(ames_sf$Gr_Liv_Area)
ames_sf1 <- ames_sf[(duplicated(ames_sf$Longitude) == FALSE), ]
####  GAM pure with pspatreg
form1 <- lnSale_Price ~ Fireplaces + Garage_Cars +
          pspl(lnLot_Area, nknots = 20) + 
          pspl(lnTotal_Bsmt_SF, nknots = 20) +
          pspl(lnGr_Liv_Area, nknots = 20)    
gampure <- pspatfit(form1, data = ames_sf1)
summary(gampure)
\donttest{
#' ########### Constructing the spatial weights matrix
coord_sf1 <- cbind(ames_sf1$Longitude, ames_sf1$Latitude)
k5nb <- knn2nb(knearneigh(coord_sf1, k = 5, 
                          longlat = TRUE, use_kd_tree = FALSE), sym = TRUE)
lw_ames <- nb2listw(k5nb, style = "W", 
                  zero.policy = FALSE)

#####################  GAM + SAR Model
gamsar <- pspatfit(form1, data = ames_sf1, 
                   type = "sar", listw = lw_ames,
                   method = "Chebyshev")
summary(gamsar)

### Compare Models
anova(gampure, gamsar, lrtest = FALSE)
## logLikelihood 
logLik(gamsar)
## Restricted logLikelihood
logLik(gamsar, REML = TRUE)
## Parametric and spatial coefficients
print(gamsar)
coef(gamsar)
## Frequentist (sandwich) covariance matrix 
## (parametric terms)
vcov(gamsar, bayesian = FALSE)      
## Bayesian covariance matrix (parametric terms)
vcov(gamsar)
#####################################
#### Fitted Values and Residuals
plot(gamsar$fitted.values, 
     ames_sf1$lnSale_Price, 
     xlab = 'fitted values', 
     ylab = "unrate",
     type = "p", cex.lab = 1.3, 
     cex.main = 1.3,
     main = "Fitted Values gamsar model")      
plot(gamsar$fitted.values, gamsar$residuals, 
     xlab = 'fitted values', ylab = "residuals",
     type = "p", cex.lab = 1.3, cex.main=1.3,
     main = "Residuals geospsar model")
}
     
}
\references{
\itemize{ 
    \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2021). 
      \emph{Regression. Models, Methods and Applications (2nd Ed.)}.
     Springer.
   }
}
\author{
\tabular{ll}{
    Roman Minguez \tab \email{roman.minguez@uclm.es} \cr
    Roberto Basile \tab \email{roberto.basile@univaq.it} \cr
    Maria Durban \tab \email{mdurban@est-econ.uc3m.es} \cr
    Gonzalo Espana-Heredia \tab \email{gehllanza@gmail.com} \cr
  }
}
