% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{transNorm}
\alias{transNorm}
\title{Transform Variables to Normality}
\usage{
transNorm(
  x,
  start = 0.01,
  family = c("bc", "yj"),
  lams,
  combine.method = c("Stouffer", "Fisher", "Average"),
  ...
)
}
\arguments{
\item{x}{Vector of values to be transformed to normality}

\item{start}{Positive value to be added to variable to ensure
all values are positive.  This follows the transformation of the variable
to have its minimum value be zero.}

\item{family}{Family of test - Box-Cox or Yeo-Johnson.}

\item{lams}{A vector of length 2 giving the range of values for the
transformation parameter.}

\item{combine.method}{String giving the method used to to combine
p-values from normality tests.}

\item{...}{Other arguments, currently unimplemented.}
}
\value{
A scalar giving the optimal transformation parameter.
}
\description{
Uses the method proposed by Velez, Correa and Marmolejo-Ramos
to normalize variables using Box-Cox or Yeo-Johnson transformations.
}
\examples{
data(wvs)
library(car)
lam <- transNorm(wvs$gdp_cap,
          family="yj",
          lams =c(-2,2))
wvs$trans_gdp <- yjPower(wvs$gdp_cap, 
             lambda=lam)
}
\references{
Velez Jorge I., Correa Juan C., Marmolejo-Ramos Fernando.  (2015)
"A new approach to the Box-Cox Transformation" Frontiers in Applied
Mathematics and Statistics.
}
