% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{srr_imp}
\alias{srr_imp}
\title{Absolute Importance Measure}
\usage{
srr_imp(
  obj,
  data,
  boot = TRUE,
  R = 250,
  level = 0.95,
  pct = FALSE,
  combine_terms = NULL,
  ...
)
}
\arguments{
\item{obj}{Model object, must be able to use \code{predict(obj, type="terms")}.}

\item{data}{A data frame used to estimate the model.}

\item{boot}{Logical indicating whether bootstrap confidence intervals should
be produced and included.}

\item{R}{If \code{boot=TRUE}, the number of bootstrap samples to be used.}

\item{level}{Confidence level used for the confidence interval.}

\item{pct}{Logical indicating whether importance figures should be turned into percentages. Default is \code{TRUE}.}

\item{combine_terms}{A named list of the names of terms to be combined into one.}

\item{...}{Other arguments being passed down to \code{boot}.}
}
\value{
A data frame of importance measures with optimal bootstrapped confidence intervals.
}
\description{
Calculates absolute importance along the lines consistent with
relative importance as defined by Silber, Rosenbaum and Ross (1995)
}
\examples{
data(gss)
mod <- glm(childs ~ sei10 + sex + educ + age, 
            data=gss, family=poisson)
srr_imp(mod, data=gss)
}
\references{
Silber, J. H., Rosenbaum, P. R. and Ross, R N (1995) Comparing the Contributions of Groups of Predictors: Which Outcomes Vary with Hospital Rather than Patient Characteristics? JASA 90, 7–18.
}
