% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_infer.R
\name{psrwe_infer}
\alias{psrwe_infer}
\title{Inference for the PS-Integrated Estimation

Inference for the PS-integrated approach.}
\usage{
psrwe_infer(dta_psrst, alternative = c("less", "greater"), mu = 0)
}
\arguments{
\item{dta_psrst}{a returned object with class \code{PSRWE_EST}}

\item{alternative}{a character string for the alternative hypothesis that
must be one of \code{"less"} (default) or \code{"greater"}}

\item{mu}{a number indicating the true value of the parameter of interest
(or the difference in means for two arms)}
}
\value{
A list with class name \code{PSRWE_EST}.
}
\description{
Inference for the PS-Integrated Estimation

Inference for the PS-integrated approach.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
ps_rst <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst <- psrwe_infer(ps_rst)
rst

}
