% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanStrAov.R
\name{meanStrAov}
\alias{meanStrAov}
\title{meanStrAov}
\usage{
meanStrAov(ezObj, effect, level, unit = "ms", numDigits = 0)
}
\arguments{
\item{ezObj}{Output from ezANOVA called with "return_aov = TRUE"}

\item{effect}{Effect to return}

\item{level}{Level of effect}

\item{unit}{"ms" vs. "mv" vs. "\%"}

\item{numDigits}{"ms" vs. "mv" vs. "\%"}
}
\value{
character
}
\description{
Returns marginal means from ezANOVA object for requested effect in Latex format.
Assumes means added to aovObj (e.g., aovObj$means <- model.tables(aovObj$aov, type = "mean").
}
\examples{
requiredPackages(c("dplyr", "ez"))
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) and 2(Side: left vs. right)
dat <- createDF(nVP = 20,
                nTrl = 50,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat, RT = list(list(c("Comp:comp", "Side:left"), vals = c(500, 150, 100)),
                                list(c("Comp:comp", "Side:right"), vals = c(500, 150, 100)),
                                list(c("Comp:incomp", "Side:left"), vals = c(520, 150, 100)),
                                list(c("Comp:incomp", "Side:right"), vals = c(520, 150, 100))))

# aggregate dat across trials
datAggVP <- dat \%>\%
    group_by(VP, Comp, Side) \%>\%
    summarize(N  = n(),
              rt = mean(RT))

# repeated measures ANOVA using ezANOVA
aovRT <- ezANOVA(datAggVP, dv=.(rt), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

meanString <- meanStrAov(aovRT, "Comp", "comp")
meanString <- meanStrAov(aovRT, "Comp:Side", "incomp:left")

\dontrun{
# Example use in *.Rnw Sweave file
# \\Sexpr{meanString} }

}
