% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r.R
\name{ma_r}
\alias{ma_r}
\title{Master framework for meta-analysis of correlations}
\usage{
ma_r(rxyi, n, n_adj = NULL, sample_id = NULL, ma_method = "bb",
  ad_type = "tsa", correction_method = "auto", construct_x = NULL,
  construct_y = NULL, measure_x = NULL, measure_y = NULL,
  construct_order = NULL, wt_type = "sample_size", error_type = "mean",
  correct_bias = TRUE, correct_rel = NULL, correct_rxx = TRUE,
  correct_ryy = TRUE, correct_rr = NULL, correct_rr_x = TRUE,
  correct_rr_y = TRUE, indirect_rr = NULL, indirect_rr_x = TRUE,
  indirect_rr_y = TRUE, rxx = NULL, rxx_restricted = TRUE,
  rxx_type = "alpha", ryy = NULL, ryy_restricted = TRUE,
  ryy_type = "alpha", ux = NULL, ux_observed = TRUE, uy = NULL,
  uy_observed = TRUE, sign_rz = NULL, sign_rxz = 1, sign_ryz = 1,
  conf_level = 0.95, cred_level = 0.8, conf_method = "t",
  cred_method = "t", var_unbiased = TRUE, moderators = NULL,
  cat_moderators = TRUE, moderator_type = "simple", pairwise_ads = FALSE,
  residual_ads = TRUE, check_dependence = TRUE,
  collapse_method = "composite", intercor = 0.5, clean_artifacts = TRUE,
  impute_artifacts = ifelse(ma_method == "ad", FALSE, TRUE),
  impute_method = "bootstrap_mod", decimals = 2, hs_override = FALSE,
  use_all_arts = FALSE, supplemental_ads = NULL, data = NULL, ...)
}
\arguments{
\item{rxyi}{Vector or column name of observed correlations}

\item{n}{Vector or column name of sample sizes.}

\item{n_adj}{Optional: Vector or column name of sample sizes adjusted for sporadic artifact corrections.}

\item{sample_id}{Optional vector of identification labels for samples/studies in the meta-analysis.}

\item{ma_method}{Method to be used to compute the meta-analysis: "bb" (barebones), "ic" (individual correction), or "ad" (artifact distribution).}

\item{ad_type}{For when ma_method is "ad", specifies the type of artifact distribution to use: "int" or "tsa".}

\item{correction_method}{Character scalar or a square matrix with the collective levels of \code{construct_x} and \code{construct_y} as row names and column names.
When ma_method is "ad", select one of the following methods for correcting artifacts: "auto", "meas", "uvdrr", "uvirr", "bvdrr", "bvirr",
"rbOrig", "rb1Orig", "rb2Orig", "rbAdj", "rb1Adj", and "rb2Adj".
(note: "rb1Orig", "rb2Orig", "rb1Adj", and "rb2Adj" can only be used when Taylor series artifact distributions are provided and "rbOrig" and "rbAdj" can only
be used when interative artifact distributions are provided). See "Details" of \code{\link{ma_r_ad}} for descriptions of the available methods.}

\item{construct_x}{Vector of construct names for construct initially designated as X.}

\item{construct_y}{Vector of construct names for construct initially designated as Y.}

\item{measure_x}{Vector of names names for measures associated with constructs initially designated as "X".}

\item{measure_y}{Vector of names names for measures associated with constructs initially designated as "Y".}

\item{construct_order}{Vector indicating the order in which variables should be arranged, with variables listed earlier in the vector being preferred for designation as X.}

\item{wt_type}{Type of weight to use in the meta-analysis: options are "sample_size", "inv_var_mean" (inverse variance computed using mean effect size), and
"inv_var_sample" (inverse variance computed using sample-specific effect sizes). Supported options borrowed from metafor are "DL", "HE", "HS", "SJ", "ML", "REML", "EB", and "PM"
(see \pkg{metafor} documentation for details about the \pkg{metafor} methods).}

\item{error_type}{Method to be used to estimate error variances: "mean" uses the mean effect size to estimate error variances and "sample" uses the sample-specific effect sizes.}

\item{correct_bias}{Logical scalar that determines whether to correct correlations for small-sample bias (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rel}{Optional named vector that supercedes \code{correct_rxx} and \code{correct_ryy}. Names should correspond to construct names in \code{construct_x} and \code{construct_y} to determine which constructs should be corrected for unreliability.}

\item{correct_rxx}{Logical scalar or vector that determines whether to correct the X variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_ryy}{Logical scalar or vector that determines whether to correct the Y variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rr}{Optional named vector that supercedes \code{correct_rr_x} and \code{correct_rr_y}. Names should correspond to construct names in \code{construct_x} and \code{construct_y} to determine which constructs should be corrected for range restriction.}

\item{correct_rr_x}{Logical scalar, logical vector or column name determining whether each correlation in \code{rxyi} should be corrected for range restriction in X (\code{TRUE}) or not (\code{FALSE}). If using artifact distribution methods, this must be a scalar value.}

\item{correct_rr_y}{Logical scalar, logical vector or column name determining whether each correlation in \code{rxyi} should be corrected for range restriction in Y (\code{TRUE}) or not (\code{FALSE}). If using artifact distribution methods, this must be a scalar value.}

\item{indirect_rr}{Optional named vector that supercedes \code{indirect_rr_x} and \code{indirect_rr_y}. Names should correspond to construct names in \code{construct_x} and \code{construct_y} to determine which constructs should be corrected for indirect range restriction.}

\item{indirect_rr_x}{Logical vector or column name determining whether each correlation in \code{rxyi} should be corrected for indirect range restriction in X (\code{TRUE}) or not (\code{FALSE}).
Superceded in evaluation by \code{correct_rr_x} (i.e., if \code{correct_rr_x} == \code{FALSE}, the value supplied for \code{indirect_rr_x} is disregarded).}

\item{indirect_rr_y}{Logical vector or column name determining whether each correlation in \code{rxyi} should be corrected for indirect range restriction in Y (\code{TRUE}) or not (\code{FALSE}).
Superceded in evaluation by \code{correct_rr_y} (i.e., if \code{correct_rr_y} == \code{FALSE}, the value supplied for \code{indirect_rr_y} is disregarded).}

\item{rxx}{Vector or column name of reliability estimates for X.}

\item{rxx_restricted}{Logical vector or column name determining whether each element of rxx is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{rxx_type, ryy_type}{String vector identifying the types of reliability estimates supplied. Acceptable reliability types are:
\itemize{
\item{internal_consistency}{\cr A generic designation for internal-consistency reliability estimates derived from responses to a single test administration.}
\item{multiple_administrations}{\cr A generic designation for reliability estimates derived from multiple administrations of a test.}
\item{alpha}{\cr Coefficient alpha.}
\item{lambda}{\cr Generic designation for a Guttman's lambda coefficient.}
\item{lambda1}{\cr Guttman's lambda 1 coefficient.}
\item{lambda2}{\cr Guttman's lambda 2 coefficient.}
\item{lambda3}{\cr Guttman's lambda 3 coefficient.}
\item{lambda4}{\cr Guttman's lambda 4 coefficient.}
\item{lambda5}{\cr Guttman's lambda 5 coefficient.}
\item{lambda6}{\cr Guttman's lambda 6 coefficient.}
\item{omega}{\cr Omega coefficient indicating the proportion variance in a variable accounted for by modeled latent factors.}
\item{icc}{\cr Intraclass correlation coefficient.}
\item{interrater_r}{\cr Inter-rater correlation coefficient.}
\item{interrater_r_sb}{\cr Inter-rater correlation coefficient, stepped up with the Spearman-Brown formula.}
\item{splithalf}{\cr Split-half reliability coefficient.}
\item{splithalf_sb}{\cr Split-half reliability coefficient, corrected toward the full test length with the Spearman-Brown formula.}
\item{retest}{\cr Test-retest reliability coefficient.}
\item{parallel}{\cr Parallel-forms reliability coefficient with tests taken during the same testing session.}
\item{alternate}{\cr Alternate-forms reliability coefficient with tests taken during the same testing session.}
\item{parallel_delayed}{\cr Parallel-forms reliability coefficient with tests taken during separate testing sessions with a time delay in between.}
\item{alternate_delayed}{\cr Alternate-forms reliability coefficient with tests taken during separate testing sessions with a time delay in between.}
}}

\item{ryy}{Vector or column name of reliability estimates for Y.}

\item{ryy_restricted}{Logical vector or column name determining whether each element of ryy is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{ux}{Vector or column name of u ratios for X.}

\item{ux_observed}{Logical vector or column name determining whether each element of ux is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{uy}{Vector or column name of u ratios for Y.}

\item{uy_observed}{Logical vector or column name determining whether each element of uy is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{sign_rz}{Optional named vector that supercedes \code{sign_rxz} and \code{sign_ryz}. Names should correspond to construct names in \code{construct_x} and \code{construct_y} to determine the sign of each construct's relationship with the selection mechanism.}

\item{sign_rxz}{Sign of the relationship between X and the selection mechanism (for use with bvirr corrections only).}

\item{sign_ryz}{Sign of the relationship between Y and the selection mechanism (for use with bvirr corrections only).}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{cred_level}{Credibility level to define the width of the credibility interval (default = .80).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{var_unbiased}{Logical scalar determining whether variances should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{cat_moderators}{Logical scalar or vector identifying whether variables in the \code{moderators} argument are categorical variables (\code{TRUE}) or continuous variables (\code{FALSE}).}

\item{moderator_type}{Type of moderator analysis: "none" means that no moderators are to be used, "simple" means that moderators are to be examined one at a time, and
"hierarchical" means that all possible combinations and subsets of moderators are to be examined.}

\item{pairwise_ads}{Logical value that determines whether to compute artifact distributions in a construct-pair-wise fashion (\code{TRUE}) or separately by construct (\code{FALSE}, default).}

\item{residual_ads}{Logical argument that determines whether to use residualized variances (\code{TRUE}) or observed variances (\code{FALSE}) of artifact distributions to estimate \code{sd_rho}.}

\item{check_dependence}{Logical scalar that determines whether database should be checked for violations of independence (\code{TRUE}) or not (\code{FALSE}).}

\item{collapse_method}{Character argument that determines how to collapase dependent studies. Options are "composite" (default), "average," and "stop."}

\item{intercor}{The intercorrelation(s) among variables to be combined into a composite. Can be a scalar or a named vector with element named according to the names of constructs.}

\item{clean_artifacts}{If \code{TRUE}, mutliple instances of the same contruct (or construct-measure pair, if measure is provided) in the database are compared and reconciled with each other
in the case that any of the matching entries within a study have different artifact values. When impute_method is anything other than "stop", this method is always implemented to prevent discrepancies among imputed values.}

\item{impute_artifacts}{If \code{TRUE}, artifact imputation will be performed (see \code{impute_method} for imputation procedures). Default is \code{FALSE} for artifact-distribution meta-analyses and \code{TRUE} otherwise.
When imputation is performed, \code{clean_artifacts} is treated as \code{TRUE} so as to resolve all rescrepancies among artifact entries before and after impuation.}

\item{impute_method}{Method to use for imputing artifacts. Choices are:
\itemize{
\item{bootstrap_mod}{\cr Select random values from the most specific moderator categories available (default).}
\item{bootstrap_full}{\cr Select random values from the full vector of artifacts.}
\item{simulate_mod}{\cr Generate random values from the distribution with the mean and variance of observed artifacts from the most specific moderator categories available.
(uses \code{rnorm} for u ratios and \code{rbeta} for reliability values).}
\item{simulate_full}{\cr Generate random values from the distribution with the mean and variance of all observed artifacts (uses \code{rnorm} for u ratios and \code{rbeta} for reliability values).}
\item{wt_mean_mod}{\cr Replace missing values with the sample-size weighted mean of the distribution of artifacts from the most specific moderator categories available (not recommended).}
\item{wt_mean_full}{\cr Replace missing values with the sample-size weighted mean of the full distribution of artifacts (not recommended).}
\item{unwt_mean_mod}{\cr Replace missing values with the unweighted mean of the distribution of artifacts from the most specific moderator categories available (not recommended).}
\item{unwt_mean_full}{\cr Replace missing values with the unweighted mean of the full distribution of artifacts (not recommended).}
\item{replace_unity}{\cr Replace missing values with 1 (not recommended).}
\item{stop}{\cr Stop evaluations when missing artifacts are encountered.}
}
If an imputation method ending in "mod" is selected but no moderators are provided, the "mod" suffix will internally be replaced with "full".}

\item{decimals}{Number of decimal places to which interactive artifact distributions should be rounded (default is 2 decimal places).}

\item{hs_override}{When \code{TRUE}, this will override settings for \code{wt_type} (will set to "sample_size"), \code{error_type} (will set to "mean"),
\code{correct_bias} (will set to \code{TRUE}), \code{conf_method} (will set to "norm"), \code{cred_method} (will set to "norm"), and \code{var_unbiased} (will set to \code{FALSE}).}

\item{use_all_arts}{Logical scalar that determines whether artifact values from studies without valid effect sizes should be used in artifact distributions (\code{TRUE}) or not (\code{FALSE}).}

\item{supplemental_ads}{Named list (named according to the constructs included in the meta-analysis) of supplemental artifact distribution information from studies not included in the meta-analysis. This is a list of lists, where the elements of a list associated with a construct are named like the arguments of the \code{create_ad()} function.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}

\item{...}{Further arguments to be passed to functions called within the meta-analysis.}
}
\value{
A list object of the classes \code{psychmeta}, \code{ma_r_as_r}, \code{ma_bb} (and \code{ma_ic} or \code{ma_ad}, as appropriate).
Components of output tables for bare-bones meta-analyses:
\itemize{
\item{\code{Pair_ID}}{\cr Unique identification number for each construct pairing.}
\item{\code{Construct_X}}{\cr Name of the variable analyzed as construct X.}
\item{\code{Construct_Y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{Analysis_ID}}{\cr Unique identification number for each moderator analysis within a construct pairing.}
\item{\code{Analysis_Type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_r}}{\cr Mean observed correlation.}
\item{\code{var_r}}{\cr Weighted variance of observed correlations.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed correlations.}
\item{\code{var_res}}{\cr Variance of observed correlations after removing predicted sampling-error variance.}
\item{\code{sd_r}}{\cr Square root of \code{var_r}.}
\item{\code{se_r}}{\cr Standard error of \code{mean_r}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_r}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_r}, where "XX" represents the confidence level as a percentage.}
\item{\code{CV_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_r}, where "XX" represents the credibility level as a percentage.}
\item{\code{CV_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_r}, where "XX" represents the credibility level as a percentage.}
}

Components of output tables for individual-correction meta-analyses:
\itemize{
\item{\code{Pair_ID}}{\cr Unique identification number for each construct pairing.}
\item{\code{Construct_X}}{\cr Name of the variable analyzed as construct X.}
\item{\code{Construct_Y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{Analysis_ID}}{\cr Unique identification number for each moderator analysis within a construct pairing.}
\item{\code{Analysis_Type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_r}}{\cr Mean observed correlation.}
\item{\code{var_r}}{\cr Weighted variance of observed correlations.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed correlations.}
\item{\code{var_res}}{\cr Variance of observed correlations after removing predicted sampling-error variance.}
\item{\code{sd_r}}{\cr Square root of \code{var_r}.}
\item{\code{se_r}}{\cr Standard error of \code{mean_r}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{mean_rho}}{\cr Mean artifact-corrected correlation.}
\item{\code{var_r_c}}{\cr Variance of artifact-corrected correlations.}
\item{\code{var_e_c}}{\cr Predicted sampling-error variance of artifact-corrected correlations.}
\item{\code{var_rho}}{\cr Variance of artifact-corrected correlations after removing predicted sampling-error variance.}
\item{\code{sd_r_c}}{\cr Square root of \code{var_r_c}.}
\item{\code{se_r_c}}{\cr Standard error of \code{mean_rho}.}
\item{\code{sd_e_c}}{\cr Square root of \code{var_e_c}.}
\item{\code{sd_rho}}{\cr Square root of \code{var_rho}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_rho}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_rho}, where "XX" represents the confidence level as a percentage.}
\item{\code{CV_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_rho}, where "XX" represents the credibility level as a percentage.}
\item{\code{CV_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_rho}, where "XX" represents the credibility level as a percentage.}
}

Components of output tables for artifact-distribution meta-analyses:
\itemize{
\item{\code{Pair_ID}}{\cr Unique identification number for each construct pairing.}
\item{\code{Construct_X}}{\cr Name of the variable analyzed as construct X.}
\item{\code{Construct_Y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{Analysis_ID}}{\cr Unique identification number for each moderator analysis within a construct pairing.}
\item{\code{Analysis_Type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_r}}{\cr Mean observed correlation.}
\item{\code{var_r}}{\cr Weighted variance of observed correlations.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed correlations.}
\item{\code{var_art}}{\cr Amount of variance in observed correlations that is attributable to measurement-error and range-restriction artifacts.}
\item{\code{var_pre}}{\cr Total predicted artifactual variance (i.e., the sum of \code{var_e} and \code{var_art})}
\item{\code{var_res}}{\cr Variance of observed correlations after removing predicted sampling-error variance and predicted artifact variance.}
\item{\code{sd_r}}{\cr Square root of \code{var_r}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_art}}{\cr Square root of \code{var_art}.}
\item{\code{sd_pre}}{\cr Square root of \code{var_pre}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{mean_rho}}{\cr Mean artifact-corrected correlation.}
\item{\code{var_rho}}{\cr Variance of artifact-corrected correlations after removing predicted sampling-error variance and predicted artifact variance.}
\item{\code{sd_rho}}{\cr Square root of \code{var_rho}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_rho}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_rho}, where "XX" represents the confidence level as a percentage.}
\item{\code{CV_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_rho}, where "XX" represents the credibility level as a percentage.}
\item{\code{CV_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_rho}, where "XX" represents the credibility level as a percentage.}
}
}
\description{
This is the master function for meta-analyses of correlations - it facilitates the computation of bare-bones, artifact-distribution, and individual-correction meta-analyses of correlations for any number of construct pairs.
When artifact-distribution meta-analyses are performed, this function will automatically extract the artifact information from a database and organize it into the requested type of artifact distribution object (i.e., either Taylor series or interactive artifact distributions).
This function is also equipped with the capability to clean databases containing inconsistently recorded artifact data, to impute missing artifacts (when individual-correction meta-analyses are requested), and remove dependency among samples by forming composites or averaging effect sizes and artifacts.
The automatic compositing features are employed when \code{sample_id}s and/or construct names are provided.
When multiple construct pairs are meta-analyzed, the result of this function takes on the class \code{ma_master}, which means that it is a list of meta-analyses. Follow-up analyses (e.g., sensitity, heterogeneity, meta-regression) performed on \code{ma_master} objects will analyze data from all meta-analyses recorded in the object.
}
\examples{
## The 'ma_r' function can compute multi-construct bare-bones meta-analyes:
ma_r(rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
     construct_x = x_name, construct_y = y_name, sample_id = sample_id,
     moderators = moderator, data = data_r_meas_multi)

## It can also perform multiple individual-correction meta-analyses:
ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
     construct_x = x_name, construct_y = y_name, sample_id = sample_id,
     moderators = moderator, data = data_r_meas_multi)

## And 'ma_r' can also curate artifact distributions and compute multiple
## artifact-distribution meta-analyses:
ma_r(ma_method = "ad", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
     correct_rr_x = FALSE, correct_rr_y = FALSE,
     construct_x = x_name, construct_y = y_name, sample_id = sample_id,
     moderators = moderator, data = data_r_meas_multi)

## Artifact information from studies not included in the meta-analysis can also be used to make
## corrections. Passing artifact information with the 'supplemental_ads' argument allows for
## additional artifact values and/or means and variances of artifacts to be used.
## The 'supplemental_ads' analysis below gives the same results as the prior meta-analysis.
x_ids <- c(data_r_meas_multi$x_name, data_r_meas_multi$y_name) == "X"
rxxi <- c(data_r_meas_multi$rxxi, data_r_meas_multi$ryyi)[x_ids]
n_rxxi = c(data_r_meas_multi$n, data_r_meas_multi$n)[x_ids]

y_ids <- c(data_r_meas_multi$x_name, data_r_meas_multi$y_name) == "Y"
ryyi <- c(data_r_meas_multi$rxxi, data_r_meas_multi$ryyi)[y_ids]
n_ryyi = c(data_r_meas_multi$n, data_r_meas_multi$n)[y_ids]

z_ids <- c(data_r_meas_multi$x_name, data_r_meas_multi$y_name) == "Z"
rzzi <- c(data_r_meas_multi$rxxi, data_r_meas_multi$ryyi)[z_ids]
n_rzzi = c(data_r_meas_multi$n, data_r_meas_multi$n)[z_ids]

ma_r(ma_method = "ad", rxyi = rxyi, n = n,
     correct_rr_x = FALSE, correct_rr_y = FALSE,
     construct_x = x_name, construct_y = y_name,
     moderators = moderator, sample_id = sample_id, data = data_r_meas_multi,
     supplemental_ads = list(X = list(rxxi = rxxi, n_rxxi = n_rxxi, wt_rxxi = n_rxxi),
                             Y = list(rxxi = ryyi, n_rxxi = n_ryyi, wt_rxxi = n_ryyi),
                             Z = list(rxxi = rzzi, n_rxxi = n_rzzi, wt_rxxi = n_rzzi)))

## If 'use_all_arts' is set to TRUE, artifacts from studies without valid correlations
## will be used to inform artifact distributions. Below, correlations and artifacts
## are provided by non-overlapping sets of studies.
dat1 <- dat2 <- data_r_meas_multi
dat1$rxxi <- dat1$ryyi <- NA
dat2$rxyi <- NA
dat2$sample_id <- dat2$sample_id + 40
dat <- rbind(dat1, dat2)
ma_r(ma_method = "ad", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
     correct_rr_x = FALSE, correct_rr_y = FALSE,
     construct_x = x_name, construct_y = y_name,
     sample_id = sample_id, moderators = moderator,
     use_all_arts = TRUE, data = dat)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \url{https://doi.org/10/b6mg}. Chapter 3.

Dahlke, J. A., & Wiernik, B. M. (2017).
\emph{One of these artifacts is not like the others: New methods to account for the unique implications of indirect range-restriction corrections in organizational research}.
Unpublished manuscript.
}
