% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predicted.merMod.R
\name{get_predicted.merMod}
\alias{get_predicted.merMod}
\title{Compute predicted values of lm models.}
\usage{
\method{get_predicted}{merMod}(fit, newdata = "model", prob = NULL,
  odds_to_probs = TRUE, iter = 100, seed = NULL, re.form = NULL,
  use.u = FALSE, ...)
}
\arguments{
\item{fit}{An lm model.}

\item{newdata}{A data frame in which to look for variables with which to predict. If omitted, the model matrix is used. If "model", the model's data is used.}

\item{prob}{Probability of confidence intervals (0.95 will compute 2.5-97.5\% CI). Can also be a list of probs (e.g., c(0.90, 0.95)). Default to NULL as it takes a very long time to compute (see \link[lme4]{bootMer}).}

\item{odds_to_probs}{Transform log odds ratios in logistic models to probabilies.}

\item{iter}{An integer indicating the number of iterations for bootstrapping (when prob is not null).}

\item{seed}{An optional seed to use.}

\item{re.form}{Formula for random effects to condition on. If NULL, include all random effects; if NA or ~0, include no random effects (see \link[lme4]{predict.merMod}).}

\item{use.u}{logical, indicating whether the spherical random effects should be simulated / bootstrapped as well. If TRUE, they are not changed, and all inference is conditional on these values. If FALSE, new normal deviates are drawn (see\link[lme4]{bootMer}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
dataframe with predicted values.
}
\description{
Compute predicted from a lm model.
}
\examples{
\dontrun{
library(psycho)
library(ggplot2)

fit <- lmerTest::lmer(Tolerating ~ Adjusting + (1|Salary), data=affective)

refgrid <- psycho::refdata(affective, "Adjusting")
predicted <- get_predicted(fit, newdata=refgrid)

ggplot(predicted, aes(x=Adjusting, y=Tolerating_Predicted)) +
  geom_line()

predicted <- get_predicted(fit, newdata=refgrid, prob=0.95, iter=100)  # Takes a long time

ggplot(predicted, aes(x=Adjusting, y=Tolerating_Predicted)) +
  geom_line() +
  geom_ribbon(aes(ymin=Tolerating_CI_2.5,
                  ymax=Tolerating_CI_97.5),
                  alpha=0.1)



fit <- lme4::glmer(Sex ~ Adjusting + (1|Salary), data=affective, family="binomial")

refgrid <- psycho::refdata(affective, "Adjusting")
predicted <- get_predicted(fit, newdata=refgrid)

ggplot(predicted, aes(x=Adjusting, y=Sex_Predicted)) +
  geom_line()

predicted <- get_predicted(fit, newdata=refgrid, prob=0.95, iter=100)  # Takes a long time

ggplot(predicted, aes(x=Adjusting, y=Sex_Predicted)) +
  geom_line() +
  geom_ribbon(aes(ymin=Sex_CI_2.5,
                  ymax=Sex_CI_97.5),
                  alpha=0.1)

}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
