% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_R2.R
\name{interpret_R2_posterior}
\alias{interpret_R2_posterior}
\title{R2 interpreation for a posterior distribution.}
\usage{
interpret_R2_posterior(posterior, rules = "cohen1988")
}
\arguments{
\item{posterior}{Distribution of R2.}

\item{rules}{Can be "cohen1988" (default), "chin1998" or "hair2013", or a custom list.}
}
\description{
Interpret R2 with a set of rules.
}
\examples{
library(psycho)
posterior <- rnorm(1000, 0.4, 0.1)
interpret_R2_posterior(posterior)
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
