% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetHumRatioFromEnthalpyAndTDryBulb}
\alias{GetHumRatioFromEnthalpyAndTDryBulb}
\title{Return humidity ratio from enthalpy and dry-bulb temperature.}
\usage{
GetHumRatioFromEnthalpyAndTDryBulb(MoistAirEnthalpy, TDryBulb)
}
\arguments{
\item{MoistAirEnthalpy}{A numeric vector of moist air enthalpy in Btu lb-1 [IP] or J kg-1}

\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]
}
\description{
Return humidity ratio from enthalpy and dry-bulb temperature.
}
\note{
Based on the \code{\link{GetMoistAirEnthalpy}} function, rearranged for humidity ratio.
}
\examples{
SetUnitSystem("IP")
GetHumRatioFromEnthalpyAndTDryBulb(42.6168, 76:86)

SetUnitSystem("SI")
GetHumRatioFromEnthalpyAndTDryBulb(81316.0, 20:30)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 30.
}
