% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetRelHumFromVapPres}
\alias{GetRelHumFromVapPres}
\title{Return relative humidity given dry-bulb temperature and vapor pressure.}
\usage{
GetRelHumFromVapPres(TDryBulb, VapPres)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{VapPres}{A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of relative humidity in range [0, 1]
}
\description{
Return relative humidity given dry-bulb temperature and vapor pressure.
}
\examples{
SetUnitSystem("IP")
GetRelHumFromVapPres(70:80, 0.0149)

SetUnitSystem("SI")
GetRelHumFromVapPres(20:30, 12581)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 12, 22
}
