% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R, R/aaa-generics.R
\docType{class}
\name{Sldax-class}
\alias{Sldax-class}
\alias{topics,Sldax-method}
\alias{topics<-,Sldax-method}
\alias{theta,Sldax-method}
\alias{theta<-,Sldax-method}
\alias{beta_,Sldax-method}
\alias{beta_<-,Sldax-method}
\alias{gamma_,Sldax-method}
\alias{gamma_<-,Sldax-method}
\alias{alpha,Sldax-method}
\alias{alpha<-,Sldax-method}
\alias{ntopics,Sldax-method}
\alias{ntopics<-,Sldax-method}
\alias{nvocab,Sldax-method}
\alias{nvocab<-,Sldax-method}
\alias{Sldax}
\title{S4 class to represent a SLDAX general model that inherits from \linkS4class{Mlr}
and \linkS4class{Logistic}.}
\usage{
\S4method{topics}{Sldax}(x)

\S4method{topics}{Sldax}(x) <- value

\S4method{theta}{Sldax}(x)

\S4method{theta}{Sldax}(x) <- value

\S4method{beta_}{Sldax}(x)

\S4method{beta_}{Sldax}(x) <- value

\S4method{gamma_}{Sldax}(x)

\S4method{gamma_}{Sldax}(x) <- value

\S4method{alpha}{Sldax}(x)

\S4method{alpha}{Sldax}(x) <- value

\S4method{ntopics}{Sldax}(x)

\S4method{ntopics}{Sldax}(x) <- value

\S4method{nvocab}{Sldax}(x)

\S4method{nvocab}{Sldax}(x) <- value

Sldax(nvocab, topics, theta, beta, ntopics = 2, alpha = 1, gamma = 1, ...)
}
\arguments{
\item{x}{An \code{Sldax} object.}

\item{value}{A value to assign to a slot for \code{x}}

\item{nvocab}{The number of terms in the corpus vocabulary.}

\item{topics}{A D x max(N_d) x M numeric array of topic draws. 0 indicates an
unused word index (i.e., the document did not have a word at that index).}

\item{theta}{A D x K x M numeric array of topic proportions.}

\item{beta}{A K x V x M numeric array of topic-vocabulary distributions.}

\item{ntopics}{The number of topics for the LDA model (default: \code{2}).}

\item{alpha}{A numeric prior hyperparameter for theta (default: \code{1.0}).}

\item{gamma}{A numeric prior hyperparameter for beta  (default: \code{1.0}).}

\item{...}{additional arguments to be passed to the low level regression
fitting functions (see below).}
}
\value{
A \linkS4class{Sldax} object.
}
\description{
S4 class to represent a SLDAX general model that inherits from \linkS4class{Mlr}
and \linkS4class{Logistic}.

Helper function (constructor) for \code{Sldax} class
}
\section{Slots}{

\describe{
\item{\code{nvocab}}{The number of terms in the corpus vocabulary.}

\item{\code{ntopics}}{The number of topics for the LDA model.}

\item{\code{alpha}}{A numeric prior hyperparameter for theta.}

\item{\code{gamma}}{A numeric prior hyperparameter for beta.}

\item{\code{topics}}{A D x max(N_d) x M numeric array of topic draws. 0 indicates an
unused word index (i.e., the document did not have a word at that index).}

\item{\code{theta}}{A D x K x M numeric array of topic proportions.}

\item{\code{beta}}{A K x V x M numeric array of topic-vocabulary distributions.}
}}

\examples{
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 1), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.5, 0.5, 0.5), dim = c(2, 2, 1)))
nvocab(m1) <- 2L
}
\keyword{classes}
