% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-utils.R
\name{pairs_plot}
\alias{pairs_plot}
\title{A pairs plot}
\usage{
pairs_plot(variables, data, by = NULL)
}
\arguments{
\item{variables}{A vector of variable names}

\item{data}{The data frame.}

\item{by}{An optional variable, usually categorical (factor or character), by
which the data are grouped and coloured.}
}
\value{
A \code{GGally::ggpairs} plot.
}
\description{
This is a wrapper to the \code{GGally} based pairs plot of a list of variables
displayed as scatterplots for pairs of continuous variables, density functions in
the diagonal, and boxplots for pairs of continuous and categorical variables.
Optionally, a \code{by} categorical variable can be provided.
}
\examples{
# A simple pairs plot
pairs_plot(variables = c("sex_dimorph", "attractive"),
data = faithfulfaces)
# A pairs plot with grouping variable
pairs_plot(variables = c("sex_dimorph", "attractive"),
by = face_sex,
data = faithfulfaces)
}
