\name{saveTable}
\alias{saveTable}
\title{
Save a table.
}
\description{
Saves a table either in rtf-format (recommended) or in HTML-format.}
\usage{
saveTable(x, file, HTML = FALSE, post.editing = TRUE)
}

\arguments{
  \item{x}{
data.frame as generated by the different xTable functions in this package (for example by the mokkenTable function).}
  \item{file}{
string; filename the table should be saved as.
}
  \item{HTML}{
logical value that toggles whether the file format should be HTML.}
\item{post.editing}{
logical value that toggles whether the tables should be post-edited. If true, hard-coded changes to the final table are made. See the details section for further informations.
}
}
\details{
If post-editing is set to true then the code, which is generated by the RTF package, is changed a posteriori.
}
\value{
None
}
\examples{
data(mydata)
test <- demographicTable(mydata$sex, mydata$age_group7, percent=FALSE)
test

#saveTable(test, "test.rtf")
}