% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muscle_fiber_dat.R
\docType{data}
\name{muscle_fiber_dat}
\alias{muscle_fiber_dat}
\title{Point cloud sampled from the muscle tissue cross-sectional image}
\format{A matrix of 6,500 rows and 2 columns}
\usage{
data(muscle_fiber_dat)
}
\description{
A dataset containing 6,500 points: 5,000 points sampled from the muscle fiber image and 1,500 points sampled from the boundary lines of the image.
}
\examples{
# load muscle fiber data
data(muscle_fiber_dat)

# input variables
Xlim <- c(-50,350)
Ylim <- c(-50,250)
lim <- cbind(Xlim, Ylim)
by <- 6
spseq <- seq(2,40,length.out = 9)

# compute persistence terrace
muscle_fiber_pt=computept(muscle_fiber_dat,sp=spseq,lim=lim,by=by)

\dontrun{
# compute persistence terrace with parallel option
spseq <- seq(2,40,length.out = 30)
two_circle_density_pt <- computept(muscle_fiber_dat,sp=spseq,lim=lim,by=by,par=TRUE)
}

# draw terrace area plot
terracearea(muscle_fiber_pt,dimension=1,maxheight=20)
# draw persistence terrace
plotpt(muscle_fiber_pt,cmax=12,dimension=1)
}
\keyword{datasets}
