% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotpt.R
\name{plotpt}
\alias{plotpt}
\title{Draws a persistence terrace.}
\usage{
plotpt(xyz, dimension, cmax = 10, satellite = T)
}
\arguments{
\item{xyz}{a list of computed persistence terraces returned by the function \link{computept}.}

\item{dimension}{an integer selecting the dimension of the persistence terrace to plot.}

\item{cmax}{an integer specifying the maximum number of colors to be used. The default value is 10.}

\item{satellite}{a logical variable to select a viewpoint. If \code{FALSE}, plots the overall view of the persistence terrace. The default value is \code{TRUE}.}
}
\value{
The function \code{plotpt} returns the persistence terrace graphic.
}
\description{
Draws a persistence terrace.
}
\examples{
# load three circle data
data(three_circle_dat)

# input variables
Xlim <- c(-4,12)
Ylim <- c(-4,9)
lim <- cbind(Xlim, Ylim)
by <- 0.1
spseq <- seq(0.01,1.5,length.out = 25)

# compute persistence terrace
\dontrun{
threecirclept <- computept(three_circle_dat,sp=spseq,lim=lim,by=by)

# draw persistence terrace, satellite view
plotpt(threecirclept,dimension=1)
# draw persistence terrace, overall view
plotpt(threecirclept,dimension=1,satellite=FALSE)
}
}
\keyword{graphics}
