% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdb_ancillary.R
\name{pdb.pep}
\alias{pdb.pep}
\title{Check Whether an Oligopeptide is Found in the PDB}
\usage{
pdb.pep(pep, pdb)
}
\arguments{
\item{pep}{character string corresponding to the sequence of the oligopeptide.}

\item{pdb}{the 4-letter PDB identifier.}
}
\value{
The functions returns TRUE if peptide is found in the PDB sequence (and gives the starting position), and FALSE otherwise.
}
\description{
Checks whether a given oligopeptide is resolved in the PDB.
}
\details{
The oligopeptide sequence must be given in one letter amino acid code.
}
\examples{
\dontrun{pdb.pep(pep = 'IVKGRASLTQEQ' , pdb = '2aw5')}
}
\seealso{
pdb.res()
}
\author{
Juan Carlos Aledo
}
